package com.bxm.mccms.common.core.service;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.core.entity.ShieldStrategy;
import com.bxm.mccms.common.model.position.PositionRefShieldStrategyVO;
import com.bxm.mccms.common.model.position.ShieldStrategyRelationPositionVO;
import com.bxm.mcssp.common.entity.IDAndNameVO;

/**
 * <p>
 * 屏蔽策略 服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-01-11
 */
public interface IShieldStrategyService extends IService<ShieldStrategy> {

    List<IDAndNameVO> getIdAndNameList(List<Long> ids);

    /**
     * 屏蔽策略关联的广告位信息
     *
     * @param page
     * @param id  屏蔽策略ID
     * @return
     */
    IPage<ShieldStrategyRelationPositionVO> getRelationPosition(Page page, Long id);

    /**
     * 广告位关联的屏蔽策略信息
     *
     * @param positionId  广告位ID
     * @return
     */
    List<PositionRefShieldStrategyVO> getRefShieldStrategy(String positionId);

    /**
     * 删除屏蔽策略关联的广告位信息
     * @param id 屏蔽策略关联的广告位信息引用ID
     * @return
     */
    boolean removeRelationPositionById(Long id);
}
