package com.bxm.mccms.common.core.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.core.entity.Task;
import com.bxm.mccms.common.model.task.TaskDTO;
import com.bxm.mccms.common.model.task.TaskDetailVO;
import com.bxm.mccms.common.model.task.TaskListVO;
import com.bxm.mccms.common.model.task.TaskQueryDTO;

/**
 * <p>
 * 任务 服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-25
 */
public interface ITaskService extends IService<Task> {

    Page<TaskListVO> page(Page page, TaskQueryDTO query);

    TaskDetailVO get(Long id);

    Task add(TaskDTO dto);

    Boolean update(TaskDTO dto);

    Boolean updatePriority(TaskDTO dto);

    Boolean updateStatus(TaskDTO dto);

    /**
     * 自动更新任务状态
     * @return
     */
    Boolean autoUpdateTaskStatus();

}
