package com.bxm.mccms.common.core.service;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.core.entity.TaskTemplate;
import com.bxm.mccms.common.model.task.TaskTemplateDTO;
import com.bxm.mccms.common.model.task.TaskTemplateJsonVO;
import com.bxm.mccms.common.model.task.TaskTemplateListVO;

/**
 * <p>
 * 任务配置模板 服务类
 * </p>
 *
 * @author kerry.jiang
 * @since 2020-07-09
 */
public interface ITaskTemplateService extends IService<TaskTemplate> {

    /**
     * 根据用户查询
     * @param userName
     * @return
     */
    List<TaskTemplateListVO> listByUser(String userName);

    /**
     * 获取模板内容
     * @param id
     * @param userName
     * @return
     */
    TaskTemplateJsonVO getTemplateByUser(Long id, String userName);

    /**
     * 新增配置
     * @param dto
     * @return
     */
    TaskTemplate add(TaskTemplateDTO dto);

    /**
     * 删除模板(物理删除)
     * @param id
     * @param userName
     * @return
     */
    Boolean deleteByUser(Long id, String userName);
}
