package com.bxm.mccms.common.core.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.service.BaseService;
import com.bxm.mcssp.common.exception.BusinessException;

/**
 * Description Mybatis PLUS ServiceImpl 扩展类
 *
 * <p>
 * Date 2019/1/18 11:53
 */
public class BaseServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<M, T> implements BaseService<T> {

    @Override
    public T findByIdWithNotNull(Serializable id) {
        T t = baseMapper.selectById(id);
        if (null == t) {
            throw new BusinessException("未查询到数据！");
        }
        return t;
    }


    @Override
    public T findOneByOneParam(String columnName, Object value) {
        QueryWrapper<T> wrapper = new QueryWrapper<>();
        wrapper.eq(columnName, value);
        wrapper.last("limit 1");
        List<T> list = baseMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<T> findListByOneParam(String columnName, Object value) {
        QueryWrapper<T> wrapper = new QueryWrapper<>();
        wrapper.eq(columnName, value);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public T findOneByOneParamWithNotNull(String columnName, Object value) {
        if (null == value) {
            throw new BusinessException("查询参数不能为空！");
        }
        T t = this.findOneByOneParam(columnName, value);
        if (null == t) {
            throw new BusinessException("未查询到数据！");
        }
        return t;
    }

    @Override
    public IPage<T> findPage(QueryWrapper<T> wrapper, Integer current, Integer size) {
        if (null == current) {
            current = 1;
        }
        if (null == size) {
            size = 20;
        }
        return baseMapper.selectPage(new Page<>(current, size), wrapper);
    }

    @Override
    public List<T> selectBatchIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return baseMapper.selectBatchIds(idList);
    }
}
