package com.bxm.mccms.common.core.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.Config;
import com.bxm.mccms.common.core.mapper.ConfigMapper;
import com.bxm.mccms.common.core.service.IConfigService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.pushable.ConfigPushable;

/**
 * <p>
 * 全局配置 服务实现类
 * </p>
 *
 * @author kerry.jiang
 * @since 2020-07-09
 */
@Service
public class ConfigServiceImpl extends ServiceImpl<ConfigMapper, Config> implements IConfigService {

    @Autowired
    private ConfigPushable configPushable;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean update(Config dto) {
        Config config = getBaseMapper().selectById(dto.getId());
        if(null == config){
            throw new McCmsException("该配置不存在");
        }
        config.setConfigValue(dto.getConfigValue());
        config.setModifyUser(dto.getModifyUser());
        config.setModifyTime(dto.getModifyTime());
        Boolean flag = getBaseMapper().updateById(config) > 0;
        //推送消息
        configPushable.push(config);
        return flag;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean batchUpdate(List<Config> dtos) {
        List<Config> list = new ArrayList<>();
        int count = 0;
        for (Config dto : dtos) {
            Config config = getBaseMapper().selectById(dto.getId());
            if(null == config){
                throw new McCmsException("该配置不存在");
            }
            config.setConfigValue(dto.getConfigValue());
            config.setModifyUser(dto.getModifyUser());
            config.setModifyTime(dto.getModifyTime());
            count += getBaseMapper().updateById(config);
            list.add(config);
        }
        Boolean flag = count > 0;
        if(flag){
            for (Config config : list) {
                //推送消息
                configPushable.push(config);
            }
        }
        return flag;
    }
}
