package com.bxm.mccms.common.core.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.DeveloperIncome;
import com.bxm.mccms.common.core.entity.PositionIncome;
import com.bxm.mccms.common.core.mapper.DeveloperIncomeMapper;
import com.bxm.mccms.common.core.mapper.PositionIncomeMapper;
import com.bxm.mccms.common.core.service.IDeveloperIncomeService;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.model.income.DeveloperIncomeDTO;
import com.bxm.mccms.common.model.income.DeveloperIncomeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author hcmony
 * @since 2020-01-10
 */
@Slf4j
@Service
public class DeveloperIncomeServiceImpl extends ServiceImpl<DeveloperIncomeMapper, DeveloperIncome> implements IDeveloperIncomeService {

    @Autowired
    private DeveloperIncomeMapper developerIncomeMapper;
    @Autowired
    private DeveloperIntegration developerIntegration;
    @Autowired
    private PositionIncomeMapper positionIncomeMapper;
    @Override
    public int init() {
        return developerIncomeMapper.init(LocalDateTimeHelper.plusDayString(-1,LocalDateTimeHelper.PATTERN_STR10)) ;
    }

    @Override
    public IPage<DeveloperIncomeVO> findAll(UserVo user, Page<DeveloperIncome> page, DeveloperIncomeDTO query) {
        String mjCode = query.getMj();

        // 当登录的mj/bd和传过来参数mj/bd不一致时不查
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank(mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page<>();
            }
            mjCode = user.getUsername();
        }

        query.setMj(mjCode);

        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        dto.setMjCode(query.getMj());
        dto.setDeveloperKeyword(query.getKeywords());

        List<DeveloperFacadeVO> providerAppList = developerIntegration.list(dto);
        if (CollectionUtils.isEmpty(providerAppList)) {
            log.warn("Developer List is Empty . mj = {}", dto.getMjCode());
            return new Page<DeveloperIncomeVO>();
        }

        QueryWrapper<DeveloperIncome> queryWrapper = new QueryWrapper<>();
        if (query.getDeveloperId() !=null){
            queryWrapper.eq(DeveloperIncome.DEVELOPER_ID,query.getDeveloperId());
        }
        List<Long> providerIdList = providerAppList.stream().map(DeveloperFacadeVO::getId).collect(Collectors.toList());
        queryWrapper.in(DeveloperIncome.DEVELOPER_ID,providerIdList);

        if (StringUtils.isNotBlank(query.getDatetime())){
            queryWrapper.eq(DeveloperIncome.DATETIME,query.getDatetime());
        }
        if (StringUtils.isNotBlank(query.getStartDate()) && StringUtils.isNotBlank(query.getEndDate())){
            queryWrapper.ge(DeveloperIncome.DATETIME, query.getStartDate());
            queryWrapper.le(DeveloperIncome.DATETIME, query.getEndDate());
        }

        Map<Long, DeveloperFacadeVO> collect = providerAppList.stream().collect(Collectors.toMap(DeveloperFacadeVO::getId, DeveloperFacadeVO -> DeveloperFacadeVO));


        final IPage<DeveloperIncome> incomeIPage = page(page, queryWrapper);
        Page<DeveloperIncomeVO> result = new Page<>();
        if (CollectionUtils.isEmpty(incomeIPage.getRecords())){
            return result;
        }
        BeanUtils.copyProperties(incomeIPage,result);
        List<DeveloperIncomeVO> developerIncomeVOS = new ArrayList<>(incomeIPage.getRecords().size());
        incomeIPage.getRecords().forEach(developerIncome ->{
            DeveloperIncomeVO vo = new DeveloperIncomeVO();
            BeanUtils.copyProperties(developerIncome,vo);
            vo.setDeveloperName(collect.get(vo.getDeveloperId()).getDeveloperName());
            developerIncomeVOS.add(vo);
        });
        result.setRecords(developerIncomeVOS);
        return result;

    }

    @Override
    public Boolean download(String datetime, String token) {
        final ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert requestAttributes != null;
        final HttpServletResponse response = requestAttributes.getResponse();



        return Boolean.TRUE;
    }

    @Override
    public Boolean upload(MultipartFile request, String token) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean publish(String datetime) {

        UserVo user = UserRoleUtil.getUser();
        UpdateWrapper<DeveloperIncome> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(DeveloperIncome.DATETIME,datetime);
        updateWrapper.lt(DeveloperIncome.STATUS,DeveloperIncome.FINISH_SUBMIT);
        DeveloperIncome income = new DeveloperIncome();
        income.setStatus(DeveloperIncome.FINISH_SUBMIT);
        income.setModifyUser(user.getUsername());

        positionIncomeMapper.updateStatusByDatetime(
                PositionIncome.FINISH_SUBMIT,
                user.getUsername(),
                datetime);
        return update(income,updateWrapper);
    }
    
    @Override
    public void updateConsume(List<PositionIncome> positionIncomes){
        // mybatis  ALL ELEMENT ARE NULL 
        positionIncomes.forEach(income -> {
            if (income == null){
                return;
            }
            DeveloperIncome developerIncome = new DeveloperIncome();
            developerIncome.setModifyUser(income.getModifyUser());
            developerIncome.setBxmPreIncome(income.getBxmPreIncome());
            developerIncome.setDeveloperPreIncome(income.getPositionPreIncome());
            developerIncome.setTotalClick(income.getTotalClick());
            developerIncome.setTotalIncome(income.getTotalIncome());
            developerIncome.setTotalOpen(income.getTotalOpen());
            developerIncome.setTotalSend(income.getTotalSend());
            UpdateWrapper<DeveloperIncome> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq(DeveloperIncome.DATETIME,income.getDatetime());
            updateWrapper.eq(DeveloperIncome.DEVELOPER_ID,income.getDeveloperId());
            //updateWrapper.lt(DeveloperIncome.STATUS,DeveloperIncome.FINISH_SUBMIT);
            update(developerIncome,updateWrapper);
        });
    }
}
