package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.DeveloperBill;
import com.bxm.mccms.common.core.entity.DeveloperWithdrawal;
import com.bxm.mccms.common.core.mapper.DeveloperBillMapper;
import com.bxm.mccms.common.core.mapper.DeveloperWithdrawalMapper;
import com.bxm.mccms.common.core.service.IDeveloperWithdrawalService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.model.PageDTO;
import com.bxm.mccms.common.model.income.DeveloperBillDTO;
import com.bxm.mccms.common.model.income.DeveloperBillVO;
import com.bxm.mccms.common.model.income.DeveloperWithdrawlVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author hcmony
 * @since 2020-01-10
 */
@Service
public class DeveloperWithdrawalServiceImpl extends ServiceImpl<DeveloperWithdrawalMapper, DeveloperWithdrawal> implements IDeveloperWithdrawalService {

    @Autowired
    private DeveloperBillMapper developerBillMapper;
    @Autowired
    private DeveloperIntegration developerIntegration;
    @Autowired
    private DeveloperBillServiceImpl developerBillService;

    @Override
    public IPage<DeveloperWithdrawlVO> findAll(Page<DeveloperBill> developerBillPage, DeveloperBillDTO query) {
//        QueryWrapper<DeveloperWithdrawal> withdrawalQueryWrapper = new QueryWrapper<>();
//        withdrawalQueryWrapper.like(StringUtils.isNotBlank(query.getKeywords()), DeveloperWithdrawal.DEVELOPER_NAME, query.getKeywords());
        //withdrawalQueryWrapper.ge(StringUtils.isNotBlank(query.getStartDate()), DeveloperWithdrawal.MONTH, query.getStartDate());
//        withdrawalQueryWrapper.le(StringUtils.isNotBlank(query.getEndDate()), DeveloperWithdrawal.MONTH, query.getEndDate());
//        withdrawalQueryWrapper.eq(null != query.getStatus(), DeveloperWithdrawal.STATUS, query.getStatus());

        //todo
        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        dto.setDeveloperKeyword(query.getKeywords());
        List<DeveloperFacadeVO> providerAppList = developerIntegration.list(dto);
        if (CollectionUtils.isEmpty(providerAppList)) {
            log.warn("Developer List  is Empty . ");
            return new Page<>();
        }

        Map<Long, DeveloperFacadeVO> collect = providerAppList.stream().collect(Collectors.toMap(DeveloperFacadeVO::getId, DeveloperFacadeVO -> DeveloperFacadeVO));

        QueryWrapper<DeveloperBill> queryWrapper = new QueryWrapper<>();
        queryWrapper.ge(StringUtils.isNotBlank(query.getStartDate()), DeveloperBill.MONTH, query.getStartDate());
        queryWrapper.le(StringUtils.isNotBlank(query.getEndDate()), DeveloperBill.MONTH, query.getEndDate());
        queryWrapper.in(DeveloperBill.DEVELOPER_ID, providerAppList.stream().map(DeveloperFacadeVO::getId).collect(Collectors.toList()));
        queryWrapper.eq(null != query.getStatus(), DeveloperBill.STATUS, query.getStatus());

        Page<DeveloperBill> p = new Page<>();
        p.setCurrent(query.getCurrent());
        p.setSize(query.getSize());
        IPage<DeveloperBill> page = developerBillService.page(p, queryWrapper);
        Page<DeveloperWithdrawlVO> result = new Page<>();
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return result;
        }

        QueryWrapper<DeveloperWithdrawal> withdrawalQueryWrapper = new QueryWrapper<>();
        withdrawalQueryWrapper.ge(StringUtils.isNotBlank(query.getStartDate()), DeveloperWithdrawal.MONTH, query.getStartDate());
        withdrawalQueryWrapper.le(StringUtils.isNotBlank(query.getEndDate()), DeveloperWithdrawal.MONTH, query.getEndDate());
        final List<DeveloperWithdrawal> list = list(withdrawalQueryWrapper);

        Map<String, DeveloperWithdrawal> developerWithdrawalMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(list)){
            list.forEach(developerWithdrawal -> {
                developerWithdrawalMap.put(developerWithdrawal.getDeveloperId()+developerWithdrawal.getMonth(),developerWithdrawal);
            });
        }

        BeanUtils.copyProperties(page, result);
        List<DeveloperWithdrawlVO> developerBillVOList = new ArrayList<>(page.getRecords().size());
        page.getRecords().forEach(developerBill -> {
            DeveloperWithdrawlVO vo = new DeveloperWithdrawlVO();
            vo.setCompanyName(collect.get(developerBill.getDeveloperId()).getCompanyName());
            vo.setDeveloperName(collect.get(developerBill.getDeveloperId()).getDeveloperName());
            vo.setMonth(developerBill.getMonth());
            vo.setCashMoney(developerBill.getCashMoney());

            final DeveloperWithdrawal developerWithdrawal = developerWithdrawalMap.get(developerBill.getDeveloperId()+developerBill.getMonth());
            if (developerWithdrawal != null) {
                BeanUtils.copyProperties(developerWithdrawal, vo);
            }
            vo.setTotalConsume(developerBill.getTotalConsume());
            vo.setDeveloperIncome(developerBill.getDeveloperIncome());
            if (vo.getStatus() == null) {
                vo.setStatus(developerBill.getStatus());
            }
            if (vo.getDeveloperId() == null) {
                vo.setDeveloperId(developerBill.getDeveloperId());
            }

            developerBillVOList.add(vo);
        });

        result.setRecords(developerBillVOList);
        // return page(page, queryWrapper);
        return result;
    }

    @Override
    public Boolean publish(Long id) {
        DeveloperWithdrawal withdrawal = getById(id);
        if (withdrawal == null) {
            throw new McCmsException("没有对应的账单，id = " + id);
        }
        if (DeveloperBill.WITHDRAWALING != withdrawal.getStatus()) {
            throw new McCmsException("账单不是提现中的状态，id = " + id);
        }
        UserVo user = UserRoleUtil.getUser();
        withdrawal.setModifyUser(user.getUsername());
        withdrawal.setStatus(DeveloperBill.WITHDRAWAL_ALREADY);
        withdrawal.setWithdrawalTime(new Date());
        saveOrUpdate(withdrawal);
        DeveloperBill bill = new DeveloperBill();
        bill.setStatus(DeveloperBill.WITHDRAWAL_ALREADY);
        UpdateWrapper<DeveloperBill> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(DeveloperBill.MONTH, withdrawal.getMonth());
        updateWrapper.eq(DeveloperBill.DEVELOPER_ID, withdrawal.getDeveloperId());
        developerBillMapper.update(bill, updateWrapper);
        return true;
    }
}
