package com.bxm.mccms.common.core.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.DspCreative;
import com.bxm.mccms.common.core.mapper.DspCreativeMapper;
import com.bxm.mccms.common.core.service.IDspCreativeService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.model.dsp.DspCreativeDTO;
import com.bxm.mccms.common.pushable.CreativePushable;
import com.bxm.mccms.facade.model.adx.CreativeFacadeVO;
import com.bxm.mccms.facade.model.adx.CreativeReviewFacadeVO;

/**
 * <p>
 * 创意审核 服务实现类
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
@Service("dspCreativeServiceImpl")
public class DspCreativeServiceImpl extends ServiceImpl<DspCreativeMapper, DspCreative> implements IDspCreativeService {

    @Autowired
    private CreativePushable creativePushable;
    
    @Override
    public Page<DspCreative> pageByAudit(Page page, DspCreativeDTO query) {
        Page<DspCreative> resp = getBaseMapper().pageByAudit(page, query);
        return resp;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public List<String> batchSave(List<DspCreative> dspCreatives) {
        List<String> crtIds = new ArrayList<>();
        for (DspCreative dspCreative : dspCreatives) {
            boolean result = save(dspCreative);
            if (result) {
                crtIds.add(dspCreative.getDspCrtid());
            }
        }
        return crtIds;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public List<String> batchUpdate(List<DspCreative> dspCreatives) {
        List<String> crtIds = new ArrayList<>();
        for (DspCreative dspCreative : dspCreatives) {
            String dspCrtId = dspCreative.getDspCrtid();
            UpdateWrapper<DspCreative> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("dsp_crtid", dspCrtId);
            updateWrapper.eq("dsp_id", dspCreative.getDspId());
            boolean result = update(dspCreative, updateWrapper);
            if (result) {
                crtIds.add(dspCrtId);
            }
        }
        return crtIds;
    }

    @Override
    public List<CreativeFacadeVO> queryCreativeByIds(List<String> dspCrtIds, Long dspId) {
        QueryWrapper<DspCreative> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("dsp_crtid", dspCrtIds);
        queryWrapper.eq("dsp_id", dspId);
        List<DspCreative> dspCreatives = list(queryWrapper);
        List<CreativeFacadeVO> creativeFacadeVOS = new ArrayList<>();
        for (DspCreative dspCreative : dspCreatives) {
            CreativeFacadeVO creativeFacadeVO = new CreativeFacadeVO();
            BeanUtils.copyProperties(dspCreative, creativeFacadeVO);
            creativeFacadeVOS.add(creativeFacadeVO);
        }
        return creativeFacadeVOS;
    }

    @Override
    public List<CreativeReviewFacadeVO> queryReviewStatus(List<String> dspCrtIds, Long dspId) {
        QueryWrapper<DspCreative> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("dsp_crtid", dspCrtIds);
        queryWrapper.eq("dsp_id", dspId);
        List<DspCreative> dspCreatives = list(queryWrapper);
        List<CreativeReviewFacadeVO> creativeReviewFacadeVOS = new ArrayList<>();
        for (DspCreative dspCreative : dspCreatives) {
            CreativeReviewFacadeVO creativeReviewFacadeVO = new CreativeReviewFacadeVO();
            BeanUtils.copyProperties(dspCreative, creativeReviewFacadeVO);
            creativeReviewFacadeVOS.add(creativeReviewFacadeVO);
        }
        return creativeReviewFacadeVOS;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean updateAuditStatus(DspCreative body) {
        DspCreative t = getById(body.getId());
        if(null == t){
            throw new McCmsException("数据不存在");
        }
        t.setAuditStatus(body.getAuditStatus());
        if(StringUtils.isNotBlank(body.getFailReason())){
            t.setFailReason(body.getFailReason());
        }
        if(StringUtils.isNotBlank(body.getRemark())){
            t.setRemark(body.getRemark());
        }
        t.setAuditTime(new Date());
        getBaseMapper().updateById(t);

        //消息推送
        creativePushable.push(t);
        return Boolean.TRUE;
    }
}
