package com.bxm.mccms.common.core.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.PositionCalcConfig;
import com.bxm.mccms.common.core.mapper.PositionCalcConfigMapper;
import com.bxm.mccms.common.core.service.IPositionCalcConfigService;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 广告位合作计费模式配置 服务实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-01-10
 */
@Slf4j
@Service
public class PositionCalcConfigServiceImpl extends ServiceImpl<PositionCalcConfigMapper, PositionCalcConfig> implements IPositionCalcConfigService {

    @Autowired
    private PositionIntegration positionIntegration;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void sycnPositionCalcConfig() {
        PositionFacadeQueryDTO dto = new PositionFacadeQueryDTO();
        List<PositionFacadeVO> positionList = positionIntegration.getAllList(dto);
        if (CollectionUtils.isEmpty(positionList)) {
            log.debug("没有需要更新的广告位");
            return;
        }
        List<PositionCalcConfig> positionCalcConfigList = new ArrayList<>();
        Date modifyTime = new Date();
        for (PositionFacadeVO positionFacadeVO : positionList) {
            PositionCalcConfig positionCalcConfig = new PositionCalcConfig();
            positionCalcConfigList.add(positionCalcConfig);

            positionCalcConfig.setPositionId(positionFacadeVO.getPositionId());

            positionCalcConfig.setCooperationType(positionFacadeVO.getCooperationType());
            positionCalcConfig.setDivideInto(positionFacadeVO.getDivideInto());
            positionCalcConfig.setBiddingType(positionFacadeVO.getBiddingType());
            positionCalcConfig.setBasePrice(positionFacadeVO.getBasePrice());
            positionCalcConfig.setStartDate(positionFacadeVO.getStartDate());
            positionCalcConfig.setEndDate(positionFacadeVO.getEndDate());

            positionCalcConfig.setOldCooperationType(positionCalcConfig.getCooperationType());
            positionCalcConfig.setOldDivideInto(positionCalcConfig.getDivideInto());
            positionCalcConfig.setOldBiddingType(positionCalcConfig.getBiddingType());
            positionCalcConfig.setOldBasePrice(positionCalcConfig.getBasePrice());
            positionCalcConfig.setOldStartDate(positionCalcConfig.getStartDate());
            positionCalcConfig.setOldEndDate(positionCalcConfig.getEndDate());

            positionCalcConfig.setCreateUser("admin");
            positionCalcConfig.setCreateTime(modifyTime);
        }
        super.saveBatch(positionCalcConfigList, 20);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void autoUpdatePositionCalcConfig() {
        PositionFacadeQueryDTO dto = new PositionFacadeQueryDTO();
        List<PositionFacadeVO> positionList = positionIntegration.getAllList(dto);
        if (CollectionUtils.isEmpty(positionList)) {
            log.debug("没有需要更新的广告位");
            return;
        }
        Map<String, PositionFacadeVO> positionMap = positionList.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);

        List<PositionCalcConfig> positionCalcConfigList = super.list();
        if (CollectionUtils.isEmpty(positionCalcConfigList)) {
            log.debug("没有需要更新的广告位配置");
            return;
        }
        for (PositionCalcConfig positionCalcConfig : positionCalcConfigList) {
            PositionFacadeVO positionFacadeVO = positionMap.get(positionCalcConfig.getPositionId());

            //更新昨天的值
            positionCalcConfig.setOldCooperationType(positionCalcConfig.getCooperationType());
            positionCalcConfig.setOldDivideInto(positionCalcConfig.getDivideInto());
            positionCalcConfig.setOldBiddingType(positionCalcConfig.getBiddingType());
            positionCalcConfig.setOldBasePrice(positionCalcConfig.getBasePrice());
            positionCalcConfig.setOldStartDate(positionCalcConfig.getStartDate());
            positionCalcConfig.setOldEndDate(positionCalcConfig.getEndDate());

            //更新今天的值
            positionCalcConfig.setCooperationType(positionFacadeVO.getCooperationType());
            positionCalcConfig.setDivideInto(positionFacadeVO.getDivideInto());
            positionCalcConfig.setBiddingType(positionFacadeVO.getBiddingType());
            positionCalcConfig.setBasePrice(positionFacadeVO.getBasePrice());
            positionCalcConfig.setStartDate(positionFacadeVO.getStartDate());
            positionCalcConfig.setEndDate(positionFacadeVO.getEndDate());
            positionCalcConfig.setModifyUser("admin");
            positionCalcConfig.setModifyTime(new Date());
        }
        super.updateBatchById(positionCalcConfigList, 20);
    }

    @Override
    public PositionCalcConfig findByPositionId(String positionId) {
        QueryWrapper<PositionCalcConfig> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(PositionCalcConfig.POSITION_ID,positionId);
        return getOne(queryWrapper);
    }
}
