package com.bxm.mccms.common.core.service.impl;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.acl.facade.model.UserRo;
import com.bxm.mccms.common.core.entity.PositionDspCreative;
import com.bxm.mccms.common.core.mapper.PositionDspCreativeMapper;
import com.bxm.mccms.common.core.service.IPositionDspCreativeService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.acl.AclUserIntegration;
import com.bxm.mccms.common.model.dsp.PositionDspCreativeDTO;
import com.bxm.mccms.common.model.dsp.PositionDspCreativeVO;
import com.bxm.mccms.common.pushable.CreativePushable;

/**
 * <p>
 * 广告位创意审核 服务实现类
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
@Service
public class PositionDspCreativeServiceImpl extends ServiceImpl<PositionDspCreativeMapper, PositionDspCreative> implements IPositionDspCreativeService {

    @Autowired
    private AclUserIntegration aclUserIntegration;
    
    @Autowired
    private CreativePushable creativePushable;
    
    @Override
    public Page<PositionDspCreativeVO> pageByAudit(Page page, PositionDspCreativeDTO query) {
        Page<PositionDspCreativeVO> resp = getBaseMapper().pageByAudit(page, query);
        List<PositionDspCreativeVO> list = page.getRecords();
        if(CollectionUtils.isEmpty(list)){
            return resp;
        }
        for(PositionDspCreativeVO vo : list){
            if (StringUtils.isNotBlank(vo.getMjCode())) {
                UserRo userRo = aclUserIntegration.getUserByUsername(vo.getMjCode());
                vo.setMjName(userRo.getName());
            }
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean updateAuditStatus(PositionDspCreative body) {
        PositionDspCreative t = getById(body.getId());
        if(null == t){
            throw new McCmsException("数据不存在");
        }
        t.setAuditStatus(body.getAuditStatus());
        if(StringUtils.isNotBlank(body.getRemark())){
            t.setRemark(body.getRemark());
        }
        t.setAuditTime(new Date());
        getBaseMapper().updateById(t);

        //消息推送
        creativePushable.push(t);
        return Boolean.TRUE;
    }
}
