package com.bxm.mccms.common.core.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bxm.datapark.web.model.SspActivity;
import com.bxm.datapark.web.model.SspActivityData;
import com.bxm.datapark.web.model.SspActivityDataDTO;
import com.bxm.mccms.common.core.entity.SceneActivity;
import com.bxm.mccms.common.core.mapper.SceneActivityMapper;
import com.bxm.mccms.common.core.service.ISceneActivityService;
import com.bxm.mccms.common.integration.datapark.DataparkWebIntegration;
import com.bxm.mccms.common.model.position.SceneActivityVO;
import com.bxm.mccms.facade.enums.SceneDspEnum;
import com.bxm.mccms.facade.model.activity.ActivityFacadeDTO;
import com.bxm.mcssp.common.util.DateUtil;

/**
 * <p>
 * 广告位场景-活动 服务实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-13
 */
@Service
public class SceneActivityServiceImpl extends BaseServiceImpl<SceneActivityMapper, SceneActivity> implements ISceneActivityService {

    @Autowired
    private DataparkWebIntegration dataparkWebIntegration;

    @Override
    public List<SspActivity> getAllActivityList(SceneDspEnum.SceneType sceneType) {
        SspActivity search = new SspActivity();
        //忽略活动状态
        search.setActivityState(null);

        //默认为sdk活动
        Integer launchControl = search.getLaunchControl();
        if(SceneDspEnum.SceneType.SCENE_TYPE_INSPIRE_VIDEO == sceneType){
            launchControl = SspActivity.LAUNCH_CONTROL_SDK_ACTIVITY;
        } else if(SceneDspEnum.SceneType.SCENE_TYPE_SDK_COMPOUND_ACTIVITY == sceneType){
            launchControl = SspActivity.LAUNCH_CONTROL_COMPOUND_ACTIVITY;
        }
        //投放控制
        search.setLaunchControl(launchControl);

        //从datapark获取活动数据，数据有延迟
        //List<SspActivity> activity = dataparkWebIntegration.getActivity(search);
        //if (CollectionUtils.isEmpty(activity)) {
        //    Collections.emptyList();
        //}

        //从活动数据库中获取数据，数据实时
        List<SspActivity> activity = getBaseMapper().findActivity(search);
        if (CollectionUtils.isEmpty(activity)) {
            Collections.emptyList();
        }
        return activity;
    }

    @Override
    public List<SceneActivityVO> getList(String positionId, String date) {
        List<SceneActivityVO> sceneActivityVOList = getBaseMapper().list(positionId);
        if (CollectionUtils.isEmpty(sceneActivityVOList)) {
            return Collections.emptyList();
        }
        
        if (StringUtils.isBlank(date)){
            date = DateUtil.dateTo8String(new Date());
        }
        List<String> activityIds = sceneActivityVOList.stream().map(SceneActivityVO::getActivityId).collect(Collectors.toList());
        //从datapark-facade获取pv,uv
        SspActivityDataDTO dto = new SspActivityDataDTO();
        dto.setThedate(date);
        dto.setPositionId(positionId);
        dto.setActivityIds(activityIds);
        List<SspActivityData> creativeDataList = dataparkWebIntegration.getActivityData(dto);
        if (CollectionUtils.isEmpty(creativeDataList)) {
            return sceneActivityVOList;
        }

        Map<String, SspActivityData> activityDataMap = creativeDataList.stream().collect(HashMap::new, (k, v) -> k.put(String.valueOf(v.getActivityId()), v), HashMap::putAll);
        for (SceneActivityVO sceneActivityVO : sceneActivityVOList) {
            SspActivityData sspActivityData = activityDataMap.get(sceneActivityVO.getActivityId());
            if (sspActivityData != null) {
                //sceneActivityVO.setActivityName(sspActivityData.getActivityName());
                sceneActivityVO.setIndexPv(sspActivityData.getIndexPv());
                sceneActivityVO.setIndexUv(sspActivityData.getIndexUv());
                sceneActivityVO.setExposurePv(sspActivityData.getExposurePv());
                sceneActivityVO.setJoinRate(sspActivityData.getJoinRate());
                sceneActivityVO.setUvPlay(sspActivityData.getUvPlay());
            }
        }
        return sceneActivityVOList;

    }

    @Override
    public Integer syncUrl(ActivityFacadeDTO dto) {
        return getBaseMapper().updateUrl(String.valueOf(dto.getActivityId()), dto.getOldActivityUrl(), dto.getNewActivityUrl());
    }
}
