package com.bxm.mccms.common.core.service.impl;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.SysDict;
import com.bxm.mccms.common.core.mapper.SysDictMapper;
import com.bxm.mccms.common.core.service.ISysDictService;

/**
 * <p>
 * 系统字典 服务实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-20
 */
@Service
public class SysDictServiceImpl extends ServiceImpl<SysDictMapper, SysDict> implements ISysDictService {

    @Override
    public List<SysDict> listAvailable(String typeCode, String parentDictValue) {
        LambdaQueryWrapper<SysDict> queryWrapper = new QueryWrapper<SysDict>().lambda()
                .eq(SysDict::getIsDictGroup, 0);

        if (StringUtils.isNotBlank(typeCode)){
            queryWrapper.eq(SysDict::getTypeCode, typeCode);
        }
        if (StringUtils.isNotBlank(parentDictValue)){
            queryWrapper.eq(SysDict::getParentDictValue, parentDictValue);
        }

        List<SysDict> sysDictList = super.list(queryWrapper);
        return sysDictList;
    }
}
