package com.bxm.mccms.common.core.service.impl;

import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.TaskRules;
import com.bxm.mccms.common.core.mapper.TaskRulesMapper;
import com.bxm.mccms.common.core.service.ITaskRulesService;
import com.bxm.mccms.facade.enums.RuleTypeEnum;

/**
 * <p>
 * 任务规则配置 服务实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-25
 */
@Service
public class TaskRulesServiceImpl extends ServiceImpl<TaskRulesMapper, TaskRules> implements ITaskRulesService {

    @Override
    public Boolean save(Long taskId, RuleTypeEnum ruleTypeEnum, String ruleValue) {
        TaskRules taskRule = new TaskRules();
        taskRule.setTaskId(taskId);
        taskRule.setRuleType(ruleTypeEnum.getValue());
        taskRule.setRuleValue(ruleValue);
        return super.save(taskRule);
    }
}
