package com.bxm.mccms.common.core.service.impl;

import java.util.List;
import java.util.Objects;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.TaskTemplate;
import com.bxm.mccms.common.core.mapper.TaskTemplateMapper;
import com.bxm.mccms.common.core.service.ITaskTemplateService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.model.task.TaskTemplateDTO;
import com.bxm.mccms.common.model.task.TaskTemplateJsonVO;
import com.bxm.mccms.common.model.task.TaskTemplateListVO;
import com.bxm.mccms.common.model.task.TaskTemplateQueryDTO;

/**
 * <p>
 * 任务配置模板 服务实现类
 * </p>
 *
 * @author kerry.jiang
 * @since 2020-07-09
 */
@Service
public class TaskTemplateServiceImpl extends ServiceImpl<TaskTemplateMapper, TaskTemplate> implements ITaskTemplateService {

    @Override
    public List<TaskTemplateListVO> listByUser(String userName) {
        TaskTemplateQueryDTO queryDTO = new TaskTemplateQueryDTO();
        queryDTO.setCreateUser(userName);
        return getBaseMapper().list(queryDTO);
    }

    @Override
    public TaskTemplateJsonVO getTemplateByUser(Long id, String userName) {
        TaskTemplate template = getBaseMapper().selectById(id);
        if(null == template){
            throw new McCmsException("模板不存在或已删除");
        }else if(!Objects.equals(template.getCreateUser(), userName)){
            throw new McCmsException("非本人模板");
        }else{
            if(StringUtils.isEmpty(template.getTemplateContent())){
                return null;
            }else{
                return JSON.parseObject(template.getTemplateContent(), TaskTemplateJsonVO.class);
            }
        }
    }

    @Override
    public TaskTemplate add(TaskTemplateDTO dto) {
        if(StringUtils.isEmpty(dto.getTemplateName())){
            throw new McCmsException("模板名称不能为空");
        }
        if(null == dto.getJson()){
            throw new McCmsException("模板内容不能为空");
        }
        dto.setTemplateContent(JSON.toJSONString(dto.getJson()));
        getBaseMapper().insert(dto);
        return dto;
    }

    @Override
    public Boolean deleteByUser(Long id, String userName) {
        TaskTemplate template = getBaseMapper().selectById(id);
        if(null == template){
            throw new McCmsException("模板不存在或已删除");
        }else if(!Objects.equals(template.getCreateUser(), userName)){
            throw new McCmsException("非本人模板");
        }else{
            return getBaseMapper().deleteById(id) > 0;
        }
    }
}
