package com.bxm.mccms.common.helper.autoconfigure;

import java.lang.reflect.Field;
import java.util.Map;

import org.apache.commons.lang3.ClassUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.helper.exception.McCmsException;

/**
 * 自动填充部分属性值<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/21 18:00
 */
@Intercepts({@Signature(type = Executor.class, method = "update",
        args = {MappedStatement.class, Object.class})})
public class AutofillFieldInterceptor implements Interceptor {

    /**
     * 注：“@Signature”的method属性值不支持“delete”和“insert”，因此insert和delete操作均使用“update”
     */
    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (SqlCommandType.DELETE.equals(sqlCommandType)) {
            //不处理“delete”
            return invocation.proceed();
        }
        Object arg = invocation.getArgs()[1];
        Object parameter = null;
        if(arg instanceof MapperMethod.ParamMap){
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)arg;
            String et = "et";
            if (paramMap.containsKey(et)) {
                parameter = paramMap.get(et);
            } else {
                //不处理
                return invocation.proceed();
            }
        } else if(arg instanceof Map){
            //不处理
            return invocation.proceed();
        } else{
            parameter = arg;
        }
        Class<?> clazz = parameter.getClass();
        //String clazzName = clazz.getName();
        // 插入语句只传一个基本类型参数, 不做处理
        if (ClassUtils.isPrimitiveOrWrapper(clazz)
                || String.class.isAssignableFrom(clazz)
                || Number.class.isAssignableFrom(clazz)) {
            //不处理
            return invocation.proceed();
        }
        
        updateField(parameter, sqlCommandType);
        return invocation.proceed();
    }

    /**
     * 填充部分属性值
     */
    private void updateField(Object parameter, SqlCommandType sqlCommandType) throws IllegalAccessException {
        Class cls = parameter.getClass();
        UserVo userVo = (UserVo)RequestContextHolder.getRequestAttributes()
                .getAttribute(AclAuthInterceptor.USER_KEY, RequestAttributes.SCOPE_REQUEST);
        
        if (SqlCommandType.INSERT.equals(sqlCommandType)) {
            try {
                Field field = cls.getDeclaredField("createUser");
                setValue(parameter, field, userVo);
            }catch (NoSuchFieldException e){
                //没找到字段，不做任何处理
            }
        } else if (SqlCommandType.UPDATE.equals(sqlCommandType)) {
            try {
                Field field = cls.getDeclaredField("modifyUser");
                setValue(parameter, field, userVo);
            }catch (NoSuchFieldException e){
                //没找到字段，不做任何处理
            }
        }
    }

    /**
     * 设置参数值
     */
    private void setValue(Object parameter, Field field, UserVo userVo) throws IllegalAccessException {
        field.setAccessible(true);
        if(null == userVo){
            if(null == field.get(parameter)){
                throw new McCmsException("AutofillFieldInterceptor: userVo is null");
                //field.set(parameter, "admin------");
                //return;
            }else{
                //使用自填参数
                return ;
            }
        }
        field.set(parameter, userVo.getUsername());
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target,this);
    }
}
