package com.bxm.mccms.common.helper.enums;

/**
 * <p>
 * 特殊的DSP枚举
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-1-12
 */
public enum DspStaticEnum {

    /**
     * 变现猫标准dsp-也叫激励视频DSP
     */
    INSPIRE_VIDEO_DSP("变现猫标准DSP", 21L, 14L),

    /**
     * 变现猫图文DSP
     */
    VIDEOTEX_DSP("变现猫图文DSP", 25L, 18L),

    /**
     * 变现猫场景DSP
     */
    SCENE_DSP("变现猫场景DSP", 20L, 13L),

    /**
     * 变现猫锁屏DSP
     */
    LOCK_SCREET_DSP("变现猫锁屏DSP", 36L, 39L),
    ;

    /**
     * Dsp名称
     */
    private String name;

    /**
     * 测试环境的DspID
     */
    private Long testId;

    /**
     * 正式环境的DspID
     */
    private Long proId;

    DspStaticEnum(String name, Long testId, Long proId) {
        this.name = name;
        this.testId = testId;
        this.proId = proId;
    }

    public String getName() {
        return name;
    }

    public Long getTestId() {
        return testId;
    }

    public Long getProId() {
        return proId;
    }

}
