package com.bxm.mccms.common.helper.enums;

/**
 * Acl 系统用户的常用角色枚举
 */
public enum RoleEnum {

    BD ("BD","BD"),
    BDLEADER ("BDleader","BD经理"),

    //MJ ("mj","媒介"),
    //MJLEADER ("mjleader","媒介经理"),
    //商业化运营专员 就是 原来的媒介
    SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN("shangyehuayunyingzhuanyuan","商业化运营专员"),
    //商业化运营经理 就是 原来的媒介经理
    SHANG_YE_HUA_YUN_YING_JING_LI("shangyehuayunyingjingli","商业化运营经理"),

    SALE ("sale","销售"),
    SALELEADER ("saleleader","销售经理"),
    AE ("ae","AE"),
    AELEADER ("aeleader","AE经理"),
    ADMIN ("admin","管理员"),
    CHAN_PIN_LEADER ("chan_pin_leader","产品经理"),
    BDPARTJOB ("bdpartjob","BD兼职"),
    RISK_CONTROL ("Risk_control","风控"),
    PING_TAI_YUN_YING_LEADER ("ping_tai_yun_ying_leader","平台运营经理"),
    ADX_TOU_FANG_ZHUAN_YUAN ("adxtoufangzhuanyuan","ADX专员"),
    CMS_UI ("CMS-UI","CMS素材库设计");

    private String code;
    private String name;

    RoleEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getNameByCode(String code) {
        for (RoleEnum temp : RoleEnum.values()) {
            if (temp.code.equals(code)) {
                return temp.name;
            }
        }
        return null;
    }

    public static String getCodeByName(String name) {
        for (RoleEnum temp : RoleEnum.values()) {
            if (temp.name.equals(name)) {
                return temp.code;
            }
        }
        return null;
    }

    public static String getCodeByUnName(String name) {
        StringBuffer sb = new StringBuffer();
        for (RoleEnum temp : RoleEnum.values()) {
            if (temp.name.equals(name)) {
                continue;
            } else {
                sb.append(temp.code).append(",");
            }
        }
        return sb.toString();
    }

}
