package com.bxm.mccms.common.helper.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bxm.mccms.common.model.income.datagrab.AdnetIncome;
import com.bxm.mccms.common.model.income.datagrab.ResultModel;
import com.bxm.mcssp.common.exception.BusinessException;

import lombok.extern.slf4j.Slf4j;

/**
 * 腾讯-优量汇数据抓取。</br>
 * Created by zhengwangeng on 2020/8/3 18:07.
 */
@Slf4j
public class AdnetUtil {

    private static final String CHROME_DRIVE_PATH = "/Users/zhengwangeng/Tool/selenium/chromedriver/84.0.4147.30/chromedriver";

    private static final String LOGIN_PAGE_URL = "https://e.qq.com/dev/index.html";

    private static final String userName = "1057235604";
    private static final String passWord = "123abc...";


    private static final String ADNET_MAIN_URL = "https://adnet.qq.com/";
    //private static final String REPORT_TABLE_DATA_URL = "https://adnet.qq.com/report/getReportTableData";
    private static final String REPORT_TABLE_DATA_URL = "https://adnet.qq.com/eros/report/report_table_data";

    //public static String getLoginSuccessCookies() throws InterruptedException {
    //    System.setProperty("webdriver.chrome.driver", CHROME_DRIVE_PATH);
    //
    //    //ChromeOptions options = new ChromeOptions();
    //    //////无界面参数
    //    ////options.addArguments("headless");
    //    //////禁用沙盒 就是被这个参数搞了一天
    //    ////options.addArguments("no-sandbox");
    //    //
    //    //WebDriver driver = new ChromeDriver(options);
    //
    //    WebDriver driver = new ChromeDriver();
    //
    //    driver.manage().deleteAllCookies();
    //    // 与浏览器同步非常重要，必须等待浏览器加载完毕
    //    driver.manage().timeouts().implicitlyWait(10, TimeUnit.SECONDS);
    //
    //    driver.get(LOGIN_PAGE_URL);
    //    TimeUnit.SECONDS.sleep(5);
    //
    //    // 获取 网页的 title
    //    System.out.println(LOGIN_PAGE_URL + " 标题为: " + driver.getTitle());
    //
    //
    //    // 点击 登录开发者平台 按钮
    //    WebElement loginBtn = driver.findElement(By.id("loginBtn"));
    //    loginBtn.click();
    //    TimeUnit.SECONDS.sleep(3);
    //
    //    String winHandleBefore = driver.getWindowHandle();
    //    for (String winHandle : driver.getWindowHandles()) {
    //        if (winHandle.equals(winHandleBefore)) {
    //            continue;
    //        }
    //        driver.switchTo().window(winHandle);
    //        break;
    //    }
    //    // 获取 网页的 title
    //    System.out.println(driver.getCurrentUrl() + " 标题为: " + driver.getTitle());
    //
    //    //#frame切换，进入frame内部才可以进行点击
    //    driver.switchTo().frame("ptlogin_iframe");
    //
    //    // 切换到账户密码登录
    //    WebElement switcher_plogin = driver.findElement(By.id("switcher_plogin"));
    //    switcher_plogin.click();
    //
    //    //输入用户名,密码
    //    WebElement u = driver.findElement(By.id("u"));
    //    u.clear();
    //    u.sendKeys(userName);
    //
    //    WebElement p = driver.findElement(By.id("p"));
    //    p.clear();
    //    p.sendKeys(passWord);
    //
    //    //点击 快速登录按钮
    //    WebElement login_button = driver.findElement(By.id("login_button"));
    //    login_button.click();
    //    TimeUnit.SECONDS.sleep(5);
    //
    //    //实际上，前面已经跳转到这个页面地址了，因为不知道怎么调回来，所以直接请求
    //    driver.navigate().to(ADNET_MAIN_URL);
    //    TimeUnit.SECONDS.sleep(3);
    //    System.out.println(driver.getCurrentUrl() + " 标题为: " + driver.getTitle());
    //
    //    //<a href="/report/list">数据查询</a>
    //    WebElement dataQuery = driver.findElement(By.linkText("数据查询"));
    //    dataQuery.click();
    //    TimeUnit.SECONDS.sleep(3);
    //    System.out.println(driver.getCurrentUrl() + " 标题为: " + driver.getTitle());
    //
    //
    //    //腾讯这边对cookie要求比较坑爹，只需要key-value，其他的都不需要，带了反而查询不到结果，提示系统繁忙
    //    StringBuffer cookiesStringBuffer = new StringBuffer();
    //    Set<Cookie> cookies = driver.manage().getCookies();
    //    BasicCookieStore basicCookieStore = new BasicCookieStore();
    //    for (Cookie cookie : cookies) {
    //        //BasicClientCookie basicClientCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
    //        //basicClientCookie.setVersion(cookie.);
    //        //basicClientCookie.setDomain(cookie.getDomain());
    //        //basicClientCookie.setPath(cookie.getPath());
    //        //basicClientCookie.setExpiryDate(cookie.getExpiry());
    //
    //        //basicCookieStore.addCookie(basicClientCookie);
    //        //System.out.println(basicCookieStore.toString());
    //        cookiesStringBuffer.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
    //    }
    //
    //    //关闭浏览器
    //    driver.quit();
    //
    //    //"pgv_pvi=4540343296; pgv_si=s5814506496; ptui_loginuin=1057235604; RK=rMAx6uBXQu; ptcz=89ec428530914279d7359fb2e4ad9141a053a0fff5895cf031ebb01aa715009d; adnet_sso_flag=1; adnet_uin=206040510085; adnet_uname=%E6%9D%AD%E5%B7%9E%E4%BA%92%E6%8E%A8%E7%A7%91%E6%8A%80%E6%9C%89%E9%99%90%E5%85%AC%E5%8F%B8; adnet_openId=3B00BD060C632E7CC685B7F5C1D396B6; adnet_sso=TGT-55253-b2BgWlY5mlwth.4xSpkr_qtYmDUv0ED_x2mTnHUJ_PvWjTEQkzxf1I.pLrfyDsZf; adnet_quality_plan_result=1; pgv_info=ssid=s4417804160; pgv_pvid=4102688368; ts_uid=9465565144; ts_last=adnet.qq.com/report/list; PLAY_SESSION=eyJhbGciOiJIUzI1NiJ9.eyJkYXRhIjp7InVpblNlc3Npb25LZXkiOiIyMDYwNDA1MTAwODUiLCJpc1N1cGVyVWluS2V5IjoiMCIsIm9wZW5JZFNlc3Npb25LZXkiOiIzQjAwQkQwNjBDNjMyRTdDQzY4NUI3RjVDMUQzOTZCNiJ9LCJuYmYiOjE1OTY1MjYyNTYsImlhdCI6MTU5NjUyNjI1Nn0.x-03kjyhYEHG6mwqTx4m5N8kCwzh5eqEk5H3YnU0tNs; adnet_li=$1$Sdcx5XIQ$X6WuWYMAXh2zlanHeERsQ0"
    //    return cookiesStringBuffer.toString();
    //}


    public static void main(String[] args) throws Exception {
        //String cookies = getLoginSuccessCookies();
        //String cookies = "1";
        String cookies = "adnet_li=$1$fdsffdfd$.KncPtMfCd/OHI3QncrEb1; adnet_openId=3B00BD060C632E7CC685B7F5C1D396B6; adnet_sso_flag=1; adnet_uin=206040510085; adnet_uname=%E6%9D%AD%E5%B7%9E%E4%BA%92%E6%8E%A8%E7%A7%91%E6%8A%80%E6%9C%89%E9%99%90%E5%85%AC%E5%8F%B8; adnet_atype=Member; adnet_sso=TGT-01740-TDJCu9HWxA_Sxhwdxq8CMOIBaOn5Q6eitawJg2nhXYz2BQvXTQekes0uf5v3UrJV; ts_refer=sso.e.qq.com/login/hub; ts_uid=784568283; pgv_info=ssid=s1732758304; pgv_pvid=5096597198; ptcz=3bfdd6fbbd624a1b489e566c3719f28359b415f9a849f830b2ee3d20ed5192e7; ptui_loginuin=1057235604; iip=0; adnet_quality_plan_result=1; XWINDEXGREY=0; Qs_lvt_323937=1586867061%2C1586867078; Qs_pv_323937=3091901844909111300%2C923290925224927100; _ga=GA1.2.1005307321.1586867078; mobileUV=1_16ed9b02ab8_e74b6; h_uid=h587215511293398379; RK=kpwV8c4dW4; tvfe_boss_uuid=a5b343053ce99f5d; pac_uid=0_95c76b68dd4e9; pgv_pvi=1514574848";

        log.info("当前cookies为:" + cookies);

        Map<String, Object> requestArgs = new HashMap<>(4);
        requestArgs.put("start_date", "2021-03-01");
        requestArgs.put("end_date", "2021-03-01");
        requestArgs.put("page", 1);
        requestArgs.put("page_size", 20);

        List<AdnetIncome.Entitie> entities = queryAllData(restTemplate(), cookies, requestArgs);
        System.out.println(entities.size());
        System.out.println(1);
    }

    /**
     * 查询所有的广告位分日数据
     * @param cookies
     * @param requestArgs
     * @return
     */
    public static List<AdnetIncome.Entitie> queryAllData(RestTemplate restTemplate, String cookies, Map<String, Object> requestArgs) {
        ArrayList<AdnetIncome.Entitie> entities = new ArrayList<>();

        ResultModel<AdnetIncome> income = query(restTemplate, cookies, requestArgs);
        AdnetIncome data = income.getData();
        if (income.getRet() == 0) {
            List<AdnetIncome.Entitie> resultEntities = data.getList();
            if (CollectionUtils.isNotEmpty(resultEntities)){
                entities.addAll(resultEntities);

                while (data.getConf().getTotal_number() > entities.size()) {
                    Integer page = (Integer)requestArgs.get("page");
                    requestArgs.put("page", page + 1);
                    requestArgs.put("page_size", 20);

                    ResultModel<AdnetIncome> nextIncome = query(restTemplate, cookies, requestArgs);
                    AdnetIncome nextData = nextIncome.getData();
                    List<AdnetIncome.Entitie> nextResultEntities = nextData.getList();
                    if (nextIncome.getRet() == 0 && CollectionUtils.isNotEmpty(nextResultEntities)) {
                        entities.addAll(nextResultEntities);
                    }
                }
            }
        }
        return entities;
    }

    private static ResultModel<AdnetIncome> query(RestTemplate restTemplate, String cookies, Map<String, Object> requestArgs) {
        try {
            ResponseEntity<String> responseEntity = query(restTemplate, REPORT_TABLE_DATA_URL, cookies, requestArgs);
            HttpStatus httpStatus = responseEntity.getStatusCode();
            if(HttpStatus.OK == httpStatus){
                String responseEntityBody = responseEntity.getBody();
                responseEntityBody = StringEscapeUtils.unescapeJava(responseEntityBody);
                //System.out.println("请求成功：" + responseEntityBody);
                return JSON.parseObject(responseEntityBody, new TypeReference<ResultModel<AdnetIncome>>() {});
            } else {
                throw new BusinessException("广点通接口请求失败！");
            }
        } catch (ResourceAccessException e) {
            //这种情况是cookie失效了，需要重新登录获取cookied
            throw new BusinessException("广点通cookie失效，接口请求失败！");
        }
    }

    private static ResponseEntity<String> query(RestTemplate restTemplate, String url, String cookie, Map<String, Object> requestArgs) {
        JSONObject requestEntity = JSONObject.parseObject("{\"start_date\":\"2021-03-01\"," +
                "\"end_date\":\"2021-03-01\",\"biz_filter\":{\"medium\":[],\"placement_type\":[],\"placement\":[]}," +
                "\"group_by\":[\"report_day\",\"placement_id\"],\"order_by\":\"\",\"page\":2,\"page_size\":20}", JSONObject.class);


        for (Map.Entry<String, Object> stringObjectEntry : requestArgs.entrySet()) {
            requestEntity.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }

        HttpHeaders headers = new HttpHeaders();
        //MediaType type = MediaType.parseMediaType("application/json;charset=UTF-8");
        //headers.setContentType(type);
        headers.setContentType(MediaType.APPLICATION_JSON);
        //headers.set("Accept", MediaType.APPLICATION_JSON.toString());
        //headers.setAccept(Arrays.asList(MediaType.ALL));

        headers.set("Pragma", "no-cache");
        headers.set("Accept", "application/json");
        headers.set("Accept-Language", "zh-cn");
        headers.set("Accept-Encoding", "gzip, deflate, br");
        headers.set("Cache-Control", "no-cache");
        headers.set("Host", "adnet.qq.com");
        headers.set("Origin", "https://adnet.qq.com");
        headers.set("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1 Safari/605.1.15");
        headers.set("Referer", "https://adnet.qq.com/report/list");
        headers.set("Connection", "keep-alive");
        headers.set("Cookie", cookie);
        HttpEntity httpEntity = new HttpEntity(requestEntity.toString(), headers);
        return restTemplate.postForEntity(url, httpEntity, String.class);
    }

    private static RestTemplate restTemplate() {
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory> create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", SSLConnectionSocketFactory.getSocketFactory())
                .build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(30);//整个连接池最大连接数
        connectionManager.setDefaultMaxPerRoute(30);//每路由最大连接数，默认值是2

        RequestConfig requestConfig = RequestConfig.custom()
                .setSocketTimeout(3000)//读取服务端数据超时
                .setConnectTimeout(3000)//建立连接超时
                .setConnectionRequestTimeout(1000)//连接池中获取请求超时
                .build();

        HttpClient httpClient = HttpClientBuilder.create()
                .setDefaultRequestConfig(requestConfig)
                .setConnectionManager(connectionManager)
                .build();
        RestTemplate restTemplate = new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient));
        //中文乱码问题
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }
}
