package com.bxm.mccms.common.helper.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bxm.mccms.common.integration.assembly.ResultModel;
import com.bxm.warcar.utils.JsonHelper;

/**
 * 组件辅助类<br/>
 *
 * @author kerry.jiang
 * @date 2020/2/14 14:37
 */
public class AssemblyUtil {

    private static HttpHeaders HEADERS = new HttpHeaders();
     
    static {
        HEADERS.setContentType(MediaType.APPLICATION_JSON);
    }

    /**
     * 组件列表<br/>
     *
     * @param restTemplate 
     * @param apiUrl API根地址
     * @param adId 广告位ID
     * @param pname 组件名称
     * @param pageNum 当前页码，默认为1
     * @param pageSize 页面大小，默认为30
     */
    public static ResponseEntity<String> getList(RestTemplate restTemplate, String apiUrl,
                                                 String adId, String pname, Integer pageNum, Integer pageSize){
        ResponseEntity<String> responseEntity = null;
        StringBuilder url = new StringBuilder(apiUrl);
        url.append("/component/getList?1=1");
        if(null == pageNum){
            url.append("&pageNum=").append(1);
        }else{
            url.append("&pageNum=").append(pageNum);
        }
        if(null == pageSize){
            url.append("&pageSize=").append(30);
        }else{
            url.append("&pageSize=").append(pageSize);
        }
        if(StringUtils.isNotBlank(adId)){
            url.append("&adId=").append(adId);
        }
        if(StringUtils.isNotBlank(pname)){
            url.append("&pname=").append(pname);
        }
        return restTemplate.getForEntity(url.toString(), String.class);
    }
    
    /**
     * 组件详情<br/>
     *
     * @param restTemplate
     * @param apiUrl API根地址
     * @param adId 广告位ID
     * @param pid 组件ID
     */
    public static ResponseEntity<String> getDetail(RestTemplate restTemplate, String apiUrl, String adId, Integer pid){
        ResponseEntity<String> responseEntity = null;
        StringBuilder url = new StringBuilder(apiUrl);
        url.append("/component/getDetail?1=1");
        if(StringUtils.isNotBlank(adId)){
            url.append("&adId=").append(adId);
        }
        if(null != pid){
            url.append("&pid=").append(pid);
        }
        return restTemplate.getForEntity(url.toString(), String.class);
    }
    
    /**
     * 组件详情<br/>
     *
     * @param restTemplate
     * @param apiUrl API根地址
     * @param adId 广告位ID
     * @param pids 组件ID列表
     */
    public static ResponseEntity<String> bind(RestTemplate restTemplate, String apiUrl, String adId, List<Integer> pids){
        ResponseEntity<String> responseEntity = null;
        StringBuilder url = new StringBuilder(apiUrl);
        url.append("/component/bind");
        Map<String, Object> request = new HashMap(2);
        request.put("adId", adId);
        request.put("pids", StringUtils.join(pids, ","));
        //封装成一个请求对象
        HttpEntity entity = new HttpEntity(request, HEADERS);
        return restTemplate.postForEntity(url.toString(), entity, String.class);
    }

    
    public static void main(String[] args) {
        String apiUrl = "http://mcmsapi-test.venomlipstick.cn";
        RestTemplate restTemplate = restTemplate();
//        ResponseEntity<String> responseEntity = getList(restTemplate, apiUrl , "test", null, 1, 30);
//
//        HttpStatus httpStatus = responseEntity.getStatusCode();
//        if(HttpStatus.OK == httpStatus){
//            ResultModel<PageModel<AssemblyList>> response = JSON.parseObject(responseEntity.getBody(),
//                    new TypeReference<ResultModel<PageModel<AssemblyList>>>() {
//                    });
//            System.out.println(JsonHelper.convert(response));
//        }else{
//            System.out.println("nonono");
//        }

        ResponseEntity<String> responseEntity = bind(restTemplate, apiUrl, "test", Arrays.asList(9));
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            ResultModel<Boolean> response = JSON.parseObject(responseEntity.getBody(),
                    new TypeReference<ResultModel<Boolean>>() {
                    });
            System.out.println(JsonHelper.convert(response));
        }else{
            System.out.println("nonono");
        }
    }

    private static RestTemplate restTemplate() {
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory> create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", SSLConnectionSocketFactory.getSocketFactory())
                .build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(30);//整个连接池最大连接数
        connectionManager.setDefaultMaxPerRoute(30);//每路由最大连接数，默认值是2

        RequestConfig requestConfig = RequestConfig.custom()
                .setSocketTimeout(500)//读取服务端数据超时
                .setConnectTimeout(500)//建立连接超时
                .setConnectionRequestTimeout(500)//连接池中获取请求超时
                .build();

        HttpClient httpClient = HttpClientBuilder.create()
                .setDefaultRequestConfig(requestConfig)
                .setConnectionManager(connectionManager)
                .build();
        return new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient));
    }
}
