package com.bxm.mccms.common.helper.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;

/**
 * 日期操作。</br>
 * Created by zhengwangeng on 2020/7/30 18:04.
 */
public class DateUtil {

    /**
     * 获取两个日期之间的月份
     *
     * @param minDate
     * @param maxDate
     * @return
     * @throws ParseException
     */
    public static List<String> getMonthBetween(String minDate, String maxDate) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        //格式化为年月
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();

        min.setTime(sdf.parse(minDate));
        min.set(min.get(Calendar.YEAR), min.get(Calendar.MONTH), 1);

        max.setTime(sdf.parse(maxDate));
        max.set(max.get(Calendar.YEAR), max.get(Calendar.MONTH), 2);

        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(Calendar.MONTH, 1);
        }
        min = null;
        max = null;
        curr = null;
        return result;
    }

    /**
     * 校验多个时间段之间是否有重叠
     * @param list 格式为 开始时间{split}结束时间
     */
    public static List<String> validatedDateOverlap(List<String> list, String split) {
        return validatedDateOverlap(list, split, "yyyy-MM-dd");
    }

    public static List<String> validatedDateOverlap(List<String> list, String split, String dateFormat) {
        List<String> errorList = new ArrayList<>();
        SimpleDateFormat formater = new SimpleDateFormat(dateFormat);
        try {
            for (int i = 0; i < list.size(); i++) {
                String d1[] = list.get(i).split(split);
                Date startdate1 = formater.parse(d1[0]);
                Date enddate1 = formater.parse(d1[1]);
                for (int j = i + 1; j < list.size(); j++) {
                    String d2[] = list.get(j).split(split);
                    Date startdate2 = formater.parse(d2[0]);
                    Date enddate2 = formater.parse(d2[1]);
                    if (!startdate2.before(startdate1)) {
                        if (!startdate2.after(enddate1)) {
                            errorList.add(list.get(i) + " 与 " + list.get(j) + " 重合\n");
                        }
                    } else if (!enddate2.before(startdate1)) {
                        errorList.add(list.get(i) + " 与 " + list.get(j) + " 重合\n");
                    }
                }
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return errorList;
    }

    public static void main(String[] args) throws ParseException {
        testYmd();
        //testHs();
    }

    private static void testHs() {
        List<String> listYmd = new ArrayList<>();
        listYmd.add("15:00#16:00");
        listYmd.add("12:00#16:00");
        listYmd.add("16:00#17:00");

        List<String> errorList = validatedDateOverlap(listYmd, "#", "HH:mm");
        if (CollectionUtils.isNotEmpty(errorList)) {
            System.out.println(errorList);
        }
    }

    private static void testYmd() {
        List<String> listYmd = new ArrayList<>();
        listYmd.add("2011-12-13#2011-12-16");
        listYmd.add("2011-12-14#2011-12-16");
        listYmd.add("2011-12-16#2011-12-30");

        List<String> errorList = validatedDateOverlap(listYmd, "#");
        if (CollectionUtils.isNotEmpty(errorList)) {
            System.out.println(errorList);
        }
    }


}
