package com.bxm.mccms.common.helper.util;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/10 17:46
 */
public class NumberUtil {

    private static final BigDecimal DECIMAL = new BigDecimal("0");

    /**
     * 两数相除，保留三位有效数字，数字>0和ROUND_UP作用一样，数字<0和ROUND_DOWN作用一样
     *
     * @param v1
     * @param v2
     * @return BigDecimal
     */

    public static BigDecimal divide(BigDecimal v1, BigDecimal v2) {
        return divide(v1,v2, BigDecimal.ROUND_CEILING );
    }

    public static BigDecimal divide(BigDecimal v1, BigDecimal v2,Integer scale) {
        if (v1 == null || v2==null){
            return null;
        }
        if (DECIMAL.equals(v2)){
            return DECIMAL;
        }

        return v1.divide(v2, scale == null?BigDecimal.ROUND_CEILING:scale, BigDecimal.ROUND_FLOOR);
    }


    public static BigDecimal add(Double v1, Double v2) {
        if (v1 == null || v2 == null) {
            return null;
        }
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.add(b2);
    }

    public static void main(String[] args) {
        System.out.println(divide(new BigDecimal("100"),new BigDecimal("3"),null).multiply(new BigDecimal("0.274956")).setScale(BigDecimal.ROUND_CEILING, BigDecimal.ROUND_FLOOR));

        System.out.println(divide(new BigDecimal("100"),new BigDecimal("3"),null).multiply(new BigDecimal("0.274956")));

        LocalDate localDate = LocalDate.now();
        LocalDate localDate1 = localDate.plusDays(-1);
        System.out.println(localDate);
        System.out.println(localDate.compareTo(localDate1));
    }

}
