package com.bxm.mccms.common.helper.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bxm.mccms.common.model.income.datagrab.ResultModel;
import com.bxm.mccms.common.model.income.datagrab.OceanengineIncome;
import com.bxm.mcssp.common.exception.BusinessException;

import lombok.extern.slf4j.Slf4j;

/**
 * 穿山甲-优量汇数据抓取。</br>
 * Created by zhengwangeng on 2020/8/3 18:07.
 */
@Slf4j
public class OceanengineUtil {

    private static final String CHROME_DRIVE_PATH = "/Users/zhengwangeng/Tool/selenium/chromedriver/84.0.4147.30/chromedriver";

    private static final String LOGIN_PAGE_URL = "https://partner.oceanengine.com/union/media/login/";

    private static final String userName = "chenyuanyuan@bianxianmao.com";
    private static final String passWord = "hutui123456";

    private static final String MAIN_URL = "https://partner.oceanengine.com/union/media/union/report/code";
    private static final String REPORT_TABLE_DATA_URL = "https://partner.oceanengine.com/union/media/api/report/v4";

    //public static String getLoginSuccessCookies() throws InterruptedException {
    //    System.setProperty("webdriver.chrome.driver", CHROME_DRIVE_PATH);
    //
    //    //ChromeOptions options = new ChromeOptions();
    //    //////无界面参数
    //    ////options.addArguments("headless");
    //    //////禁用沙盒 就是被这个参数搞了一天
    //    ////options.addArguments("no-sandbox");
    //    //
    //    //WebDriver driver = new ChromeDriver(options);
    //
    //    WebDriver driver = new ChromeDriver();
    //
    //    driver.manage().deleteAllCookies();
    //    // 与浏览器同步非常重要，必须等待浏览器加载完毕
    //    driver.manage().timeouts().implicitlyWait(10, TimeUnit.SECONDS);
    //
    //    driver.get(LOGIN_PAGE_URL);
    //    TimeUnit.SECONDS.sleep(5);
    //
    //    // 获取 网页的 title
    //    System.out.println(LOGIN_PAGE_URL + " 标题为: " + driver.getTitle());
    //
    //
    //    // 点击 登录开发者平台 按钮
    //    WebElement loginBtn = driver.findElement(By.id("loginBtn"));
    //    loginBtn.click();
    //    TimeUnit.SECONDS.sleep(3);
    //
    //    String winHandleBefore = driver.getWindowHandle();
    //    for (String winHandle : driver.getWindowHandles()) {
    //        if (winHandle.equals(winHandleBefore)) {
    //            continue;
    //        }
    //        driver.switchTo().window(winHandle);
    //        break;
    //    }
    //    // 获取 网页的 title
    //    System.out.println(driver.getCurrentUrl() + " 标题为: " + driver.getTitle());
    //
    //    //#frame切换，进入frame内部才可以进行点击
    //    driver.switchTo().frame("ptlogin_iframe");
    //
    //    // 切换到账户密码登录
    //    WebElement switcher_plogin = driver.findElement(By.id("switcher_plogin"));
    //    switcher_plogin.click();
    //
    //    //输入用户名,密码
    //    WebElement u = driver.findElement(By.id("u"));
    //    u.clear();
    //    u.sendKeys(userName);
    //
    //    WebElement p = driver.findElement(By.id("p"));
    //    p.clear();
    //    p.sendKeys(passWord);
    //
    //    //点击 快速登录按钮
    //    WebElement login_button = driver.findElement(By.id("login_button"));
    //    login_button.click();
    //    TimeUnit.SECONDS.sleep(5);
    //
    //    //实际上，前面已经跳转到这个页面地址了，因为不知道怎么调回来，所以直接请求
    //    driver.navigate().to(MAIN_URL);
    //    TimeUnit.SECONDS.sleep(3);
    //    System.out.println(driver.getCurrentUrl() + " 标题为: " + driver.getTitle());
    //
    //    //<a href="/report/list">数据查询</a>
    //    WebElement dataQuery = driver.findElement(By.linkText("数据查询"));
    //    dataQuery.click();
    //    TimeUnit.SECONDS.sleep(3);
    //    System.out.println(driver.getCurrentUrl() + " 标题为: " + driver.getTitle());
    //
    //
    //    //腾讯这边对cookie要求比较坑爹，只需要key-value，其他的都不需要，带了反而查询不到结果，提示系统繁忙
    //    StringBuffer cookiesStringBuffer = new StringBuffer();
    //    Set<Cookie> cookies = driver.manage().getCookies();
    //    BasicCookieStore basicCookieStore = new BasicCookieStore();
    //    for (Cookie cookie : cookies) {
    //        //BasicClientCookie basicClientCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
    //        //basicClientCookie.setVersion(cookie.);
    //        //basicClientCookie.setDomain(cookie.getDomain());
    //        //basicClientCookie.setPath(cookie.getPath());
    //        //basicClientCookie.setExpiryDate(cookie.getExpiry());
    //
    //        //basicCookieStore.addCookie(basicClientCookie);
    //        //System.out.println(basicCookieStore.toString());
    //        cookiesStringBuffer.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
    //    }
    //
    //    //关闭浏览器
    //    driver.quit();
    //
    //    //"pgv_pvi=4540343296; pgv_si=s5814506496; ptui_loginuin=1057235604; RK=rMAx6uBXQu; ptcz=89ec428530914279d7359fb2e4ad9141a053a0fff5895cf031ebb01aa715009d; adnet_sso_flag=1; adnet_uin=206040510085; adnet_uname=%E6%9D%AD%E5%B7%9E%E4%BA%92%E6%8E%A8%E7%A7%91%E6%8A%80%E6%9C%89%E9%99%90%E5%85%AC%E5%8F%B8; adnet_openId=3B00BD060C632E7CC685B7F5C1D396B6; adnet_sso=TGT-55253-b2BgWlY5mlwth.4xSpkr_qtYmDUv0ED_x2mTnHUJ_PvWjTEQkzxf1I.pLrfyDsZf; adnet_quality_plan_result=1; pgv_info=ssid=s4417804160; pgv_pvid=4102688368; ts_uid=9465565144; ts_last=adnet.qq.com/report/list; PLAY_SESSION=eyJhbGciOiJIUzI1NiJ9.eyJkYXRhIjp7InVpblNlc3Npb25LZXkiOiIyMDYwNDA1MTAwODUiLCJpc1N1cGVyVWluS2V5IjoiMCIsIm9wZW5JZFNlc3Npb25LZXkiOiIzQjAwQkQwNjBDNjMyRTdDQzY4NUI3RjVDMUQzOTZCNiJ9LCJuYmYiOjE1OTY1MjYyNTYsImlhdCI6MTU5NjUyNjI1Nn0.x-03kjyhYEHG6mwqTx4m5N8kCwzh5eqEk5H3YnU0tNs; adnet_li=$1$Sdcx5XIQ$X6WuWYMAXh2zlanHeERsQ0"
    //    return cookiesStringBuffer.toString();
    //}


    public static void main(String[] args) throws Exception {
        //String cookies = getLoginSuccessCookies();
        //String cookies = "1";
        String cookies = "SLARDAR_WEB_ID=a53be83a-f4ed-4781-8d2e-fc264e2c46aa; " +
                "Hm_lpvt_64d8d9aaa00cd643749093c0625403c3=1596793467; " +
                "Hm_lvt_64d8d9aaa00cd643749093c0625403c3=1596438684,1596793467; " +
                "session" +
                "=eyJjc3JmX3Rva2VuIjp7IiBiIjoiWkRGbFlqazBOMk00TXpBNU1qRTJNakl6WVRVeU9UVmxNbUV5WVRrMFpUaGtNemt6TkdaaE13PT0ifX0.Xy0ieg.nQI8YjudtsJHk0RWl2vNxXaf-2o; sessionid=000c13ad075527bbfb512681bf3aa9ff; sessionid_ss=000c13ad075527bbfb512681bf3aa9ff; sid_guard=000c13ad075527bbfb512681bf3aa9ff%7C1596444360%7C5184000%7CFri%2C+02-Oct-2020+08%3A46%3A00+GMT; sid_tt=000c13ad075527bbfb512681bf3aa9ff; uid_tt=1e445f0c1d1d9c406abc3b1497699aed; uid_tt_ss=1e445f0c1d1d9c406abc3b1497699aed\n";

        String XCSRFToken = "ImQxZWI5NDdjODMwOTIxNjIyM2E1Mjk1ZTJhMmE5NGU4ZDM5MzRmYTMi.Xy0i0Q.awL4JhhtgD8pPVjtMJAEYKZjtrM";
        log.info("当前cookies为:" + cookies);
        log.info("当前X_CSRFToken为:" + XCSRFToken);

        Map<String, Object> requestArgs = new HashMap<>(4);
        requestArgs.put("StartDate", "2020-06-28");
        requestArgs.put("EndDate", "2020-08-06");
        requestArgs.put("Page", 1);
        requestArgs.put("PageSize", 100);

        List<OceanengineIncome.Entitie> entities = queryAllData(restTemplate(), cookies, XCSRFToken, requestArgs);
        System.out.println("共查询到 " + entities.size() + " 条记录！");
        Map<Integer, OceanengineIncome.Entitie> codeIdMap = entities.stream().collect(HashMap::new, (k, v) -> k.put(v.getCodeId(), v), HashMap::putAll);

    }

    /**
     * 查询所有的广告位分日数据
     * @param cookies
     * @param requestArgs
     * @return
     */
    public static List<OceanengineIncome.Entitie> queryAllData(RestTemplate restTemplate, String cookies, String XCSRFToken, Map<String, Object> requestArgs) {
        ArrayList<OceanengineIncome.Entitie> entities = new ArrayList<>();

        ResultModel<OceanengineIncome> income = query(restTemplate, cookies, XCSRFToken, requestArgs);
        OceanengineIncome data = income.getData();
        List<OceanengineIncome.Entitie> resultEntities = data.getDataList();
        if (income.getCode() == 0 && CollectionUtils.isNotEmpty(resultEntities)) {
            entities.addAll(resultEntities);

            while (data.getPagination().getTotal() > entities.size()) {
                Integer page = (Integer)requestArgs.get("Page");
                requestArgs.put("Page", page + 1);

                ResultModel<OceanengineIncome> nextIncome = query(restTemplate, cookies, XCSRFToken, requestArgs);
                OceanengineIncome nextData = nextIncome.getData();
                List<OceanengineIncome.Entitie> nextResultEntities = nextData.getDataList();
                if (nextIncome.getCode() == 0 && CollectionUtils.isNotEmpty(nextResultEntities)) {
                    entities.addAll(nextResultEntities);
                }
            }
        }
        return entities;
    }

    private static ResultModel<OceanengineIncome> query(RestTemplate restTemplate, String cookies, String XCSRFToken, Map<String, Object> requestArgs) {
        ResponseEntity<String> responseEntity = query(restTemplate, REPORT_TABLE_DATA_URL, cookies, XCSRFToken, requestArgs);
        if (responseEntity == null) {
            throw new BusinessException("穿山甲接口请求异常！");
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            String responseEntityBody = responseEntity.getBody();
            //System.out.println("请求成功1：" + responseEntityBody);
            responseEntityBody = StringEscapeUtils.unescapeJava(responseEntityBody);
            //System.out.println("请求成功2：" + responseEntityBody);
            return JSON.parseObject(responseEntityBody, new TypeReference<ResultModel<OceanengineIncome>>() {});
        } else {
            throw new BusinessException("穿山甲接口请求失败！");
        }

    }

    private static ResponseEntity<String> query(RestTemplate restTemplate, String url, String cookie, String XCSRFToken, Map<String, Object> requestArgs) {
        HashMap<String, Object> stringObjectHashMap = new HashMap<>();
        stringObjectHashMap.put("DataType", "code");
        stringObjectHashMap.put("EndDate", "2020-08-06");
        stringObjectHashMap.put("ModalSearchType", "site");
        stringObjectHashMap.put("Page", 1);
        stringObjectHashMap.put("PageSize", 30);
        stringObjectHashMap.put("StartDate", "2020-07-31");
        stringObjectHashMap.put("Type", 1);

        for (Map.Entry<String, Object> stringObjectEntry : requestArgs.entrySet()) {
            stringObjectHashMap.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        StringBuffer argsStringBuffer = new StringBuffer();
        for (Map.Entry<String, Object> stringObjectEntry : stringObjectHashMap.entrySet()) {
            argsStringBuffer.append(stringObjectEntry.getKey());
            argsStringBuffer.append("=");
            argsStringBuffer.append(stringObjectEntry.getValue());
            argsStringBuffer.append("&");
        }

        HttpHeaders headers = new HttpHeaders();
        //headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MediaType type = MediaType.parseMediaType("application/x-www-form-urlencoded; charset=UTF-8");
        headers.setContentType(type);
        //headers.set("Content-Type", "application/x-www-form-urlencoded");

        headers.set("Pragma", "no-cache");

        headers.set("Accept", "application/json");
        //headers.set("Accept", "*/*");
        //headers.set("Accept", MediaType.APPLICATION_JSON.toString());
        //headers.setAccept(Arrays.asList(MediaType.ALL));

        headers.set("Accept-Language", "zh-cn");
        //headers.set("Accept-Language", "zh-CN,zh;q=0.9");

        headers.set("Cache-Control", "no-cache");
        headers.set("Accept-Encoding", "gzip, deflate, br");
        headers.set("Host", "partner.oceanengine.com");
        headers.set("Origin", "https://partner.oceanengine.com");
        //headers.set("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1 Safari/605.1.15");
        headers.set("User-Agent", "User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1 Safari/605.1.15");
        headers.set("Referer", "https://partner.oceanengine.com/union/media/union/report/code");
        headers.set("Connection", "keep-alive");
        headers.set("Cookie", cookie);
        headers.set("X-CSRFToken", XCSRFToken);
        HttpEntity httpEntity = new HttpEntity(argsStringBuffer.toString(), headers);
        return restTemplate.postForEntity(url, httpEntity, String.class);
    }

    private static RestTemplate restTemplate() {
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory> create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", SSLConnectionSocketFactory.getSocketFactory())
                .build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(30);//整个连接池最大连接数
        connectionManager.setDefaultMaxPerRoute(30);//每路由最大连接数，默认值是2

        RequestConfig requestConfig = RequestConfig.custom()
                .setSocketTimeout(3000)//读取服务端数据超时
                .setConnectTimeout(3000)//建立连接超时
                .setConnectionRequestTimeout(1000)//连接池中获取请求超时
                .build();

        HttpClient httpClient = HttpClientBuilder.create()
                .setDefaultRequestConfig(requestConfig)
                .setConnectionManager(connectionManager)
                .build();
        RestTemplate restTemplate = new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient));
        //中文乱码问题
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }
}
