package com.bxm.mccms.common.helper.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.jsoup.helper.StringUtil;

import com.bxm.mcssp.common.util.DateUtil;

public class StartAndEndTimeUtil {

    /**
     * 判断开始与结束时间
     * @param startDate
     * @param endDate
     * @return
     */
    public static Map<String, Date> getStartAndEndTime(String startDate, String endDate) {
        Map<String, Date> dateTimes = new HashMap<String, Date>();
        //截至日期最晚到昨天
        Date yestoday = DateUtil.getDayFirsttime(DateUtil.increaseDate(new Date(), -1));
        //默认查询近14天的数据
        Date start = StringUtils.isBlank(startDate) ? DateUtil.increaseDate(yestoday, -14) : DateUtil.StringToDate(startDate);
        Date end = StringUtil.isBlank(endDate) ? yestoday : DateUtil.StringToDate(endDate);
        //如果开始时间在结束时间之后
        if (DateUtil.isAfter(end, start)) {
            //开始与结束时间都是昨天
            start = yestoday;
            end = yestoday;
        }
        //查询最晚时间为昨日
        if (end.after(yestoday)) {
            end = yestoday;
        }
        dateTimes.put("startTime", start);//开始时间
        dateTimes.put("endTime", end);//结束时间
        return dateTimes;
    }

    /**
     * 根据开始时间和结束时间设置结果时间段集合
     * @param dateTime  开始时间和结束时间
     * @return
     */
    public static String[] setResultDateTime(Map<String, Date> dateTime) {
        Long startTime = dateTime.get("startTime").getTime();
        Long endTime = dateTime.get("endTime").getTime();;
        //日期集合
        ArrayList<String> dateList = new ArrayList<String>();
        while (startTime <= endTime) {
            String datetime = DateUtil.dateToFormat(new Date(startTime),"yyyy-MM-dd");
            //添加时间
            dateList.add(datetime);
            startTime += (long)24*60*60*1000;
        }
        String[] dateArray = new String[dateList.size()];
        dateList.toArray(dateArray);

        return dateArray;
    }
}
