package com.bxm.mccms.common.integration.acl;

import java.util.Collections;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Service;

import com.bxm.acl.facade.AclUserService;
import com.bxm.acl.facade.model.ResultModel;
import com.bxm.acl.facade.model.UserRo;

import lombok.extern.slf4j.Slf4j;

/**
 * <h3>用户权限</h3>
 * <p></p>
 *
 * @author yirenjie
 * createDate:  2018/10/19
 */
@Slf4j
@Service
@EnableFeignClients("com.bxm.acl.facade")
public class AclUserIntegration {

    @Resource
    private AclUserService aclUserService;

    public Map<String, String> queryUserByRoleCode(String roleCode, Boolean onlyShowEnable) {
        try {
            ResultModel<Map<String, String>> response = aclUserService.queryUserByRoleCode(roleCode, onlyShowEnable);
            if (response != null && response.isSuccessed() && response.getReturnValue() != null) {
                return response.getReturnValue();
            }
        } catch (Exception e){
            log.error("请求权限系统查询角色对应用户信息异常:", e);
        }
        return Collections.emptyMap();
    }

    public UserRo getUserByUsername(String username) {
        try {
            ResultModel<UserRo> response = aclUserService.getUserByUsername(username);
            if (response != null && response.isSuccessed() && response.getReturnValue() != null) {
                return response.getReturnValue();
            }
        } catch (Exception e) {
            log.error("请求权限系统查询username对应用户信息异常:", e);
        }
        return null;
    }
}
