package com.bxm.mccms.common.integration.adx;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Service;

import com.bxm.adx.facade.model.task.TaskCounter;
import com.bxm.adx.facade.service.TaskService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 任务 远程调用服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-26
 */
@Slf4j
@Service
@EnableFeignClients("com.bxm.adx.facade.service")
public class TaskIntegration {

    @Resource
    private TaskService taskService;

    /**
     * 批量获取任务统计信息
     * @param idsStr 任务id 字符串，用逗号分隔
     * @return
     */
    public List<TaskCounter> list(String idsStr) {
        List<TaskCounter> taskCounterList = taskService.getByIds(idsStr);
        return taskCounterList;
    }


}
