package com.bxm.mccms.common.integration.assembly;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bxm.mccms.common.helper.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.mccms.common.helper.autoconfigure.config.AssemblyConfig;
import com.bxm.mccms.common.helper.util.AssemblyUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * 组件<br/>
 *
 * @author kerry.jiang
 * @date 2020/2/14 13:21
 */
@Slf4j
@Service
@EnableConfigurationProperties(ApplicationGlobalConfig.class)
public class AssemblyIntegration {

    private AssemblyConfig assemblyConfig;
    @Resource
    private RestTemplate restTemplate;

    public AssemblyIntegration(ApplicationGlobalConfig applicationGlobalConfig){
        this.assemblyConfig = applicationGlobalConfig.getAssembly();
    }

    /**
     * 组件列表<br/>
     *
     * @param adId 广告位ID
     * @param pname 组件名称
     * @param pageNum 当前页码，默认为1
     * @param pageSize 页面大小，默认为30
     */
    public ResultModel<PageModel<AssemblyList>> getList(String adId, String pname, Integer pageNum, Integer pageSize){
        //if(StringUtils.isBlank(adId)){//必选项
        //    return null;
        //}
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = AssemblyUtil.getList(this.restTemplate, assemblyConfig.getApiUrl(), adId,
                    pname, pageNum, pageSize);
        }catch (Exception e){
            log.error("getList error: adId={}, e={}",
                    adId, ExceptionUtils.getFullStackTrace(e));
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            ResultModel<PageModel<AssemblyList>> response = JSON.parseObject(responseEntity.getBody(),
                    new TypeReference<ResultModel<PageModel<AssemblyList>>>() {
            });
            return response;
        }else{
            log.warn("getList httpStatus: ", httpStatus.value());
            return null;
        }
    }

    /**
     * 组件详情<br/>
     *
     * @param adId 广告位ID
     * @param pid 组件ID
     */
    public ResultModel<AssemblyDetail> getDetail(String adId, Integer pid){
        if(StringUtils.isBlank(adId) || null == pid){
            return null;
        }
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = AssemblyUtil.getDetail(this.restTemplate, assemblyConfig.getApiUrl(), adId, pid);
        }catch (Exception e){
            log.error("getDetail error: adId={}, pid={}, e={}",
                    adId, pid, ExceptionUtils.getFullStackTrace(e));
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            ResultModel<AssemblyDetail> response = JSON.parseObject(responseEntity.getBody(),
                    new TypeReference<ResultModel<AssemblyDetail>>() {
            });
            return response;
        }else{
            log.warn("getDetail httpStatus: ", httpStatus.value());
            return null;
        }
    }

    /**
     * 绑定组件<br/>
     *
     * @param adId 广告位ID
     * @param pids 组件ID列表
     */
    public ResultModel<Boolean> bind(String adId, List<Integer> pids){
        if(StringUtils.isBlank(adId)){
            return null;
        }
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = AssemblyUtil.bind(this.restTemplate, assemblyConfig.getApiUrl(), adId, pids);
        }catch (Exception e){
            log.error("bind error: adId={}, pids={}, e={}",
                    adId, StringUtils.join(pids, ","), ExceptionUtils.getFullStackTrace(e));
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            ResultModel<Boolean> response = JSON.parseObject(responseEntity.getBody(),
                    new TypeReference<ResultModel<Boolean>>() {
            });
            return response;
        }else{
            log.warn("bind httpStatus: ", httpStatus.value());
            return null;
        }
    }
}
