package com.bxm.mccms.common.integration.pushable;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.constant.pushable.CachePushableTopicEnum;
import com.bxm.warcar.integration.pushable.CachePushableService;
import com.bxm.warcar.integration.pushable.message.MessageEntity;

import lombok.extern.slf4j.Slf4j;

/**
 * 推送数据到前端<br/>
 * 将数据推送到<code>serviceName</code>服务，对应的服务接收到请求后<br/>
 * 根据<code>parameters</code>参数约定来生成缓存的KEY，<br/>
 * 最后将<code>data</code>数据更新到响应的缓存中。
 *
 * @author kerry.jiang
 * @date 2019/12/26 15:22
 */
@Slf4j
@Service
public class CachePushableIntegration {
	
	@Autowired
	private CachePushableService cachePushableService;

	/**
	 * 推送数据到前端<br/>
	 * 默认主题<br/>
	 */
	public String push(CachePushableServiceEnum service, byte[] data,
					   Map<String, Object> parameters) throws Exception{
		return push(service, data, parameters, CachePushableTopicEnum.DEFAULT);
	}

	/**
	 * 推送数据到前端<br/>
	 *
	 * @param service @see ServiceNameEnum
	 * @param data 数据
	 * @param parameters 参数
	 * @param topic 主题
	 * @return 推送反馈结果
	 */
	public String push(CachePushableServiceEnum service, byte[] data,
					   Map<String, Object> parameters, CachePushableTopicEnum topic) throws Exception{
		log.info("推送数据到前端serviceName={}", service.getName());
		MessageEntity entity = new MessageEntity(service.getName(), parameters, data);
		return cachePushableService.push(entity, topic.getName());
	}
}
