package com.bxm.mccms.common.integration.ssp.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.BeanUtils;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mccms.common.model.app.AppForItemVO;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.app.AppFacadeDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeQueryDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeVO;
import com.bxm.mcssp.facade.model.app.AppWaitingAuditFacadeVO;
import com.bxm.mcssp.facade.service.AppFacadeService;

import lombok.extern.slf4j.Slf4j;


/**
 * <p>
 * 应用 远程调用服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-22
 */
@Slf4j
@Service
@EnableFeignClients("com.bxm.mcssp.facade")
public class AppIntegration {

    @Resource
    private AppFacadeService appFacadeService;

    /**
     * ID和名称数据
     * @param keyword
     * @return
     */
    public List<IDAndNameVO> list(String keyword) {
        ResponseEntity<List<IDAndNameVO>> resultModel = appFacadeService.list(keyword);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者列表失败！-->{}", resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    /**
     * 分页查询
     * @param dto
     * @return
     */
    public IPage<AppFacadeVO> page(AppFacadeQueryDTO dto) {
        ResponseEntity<Page<AppFacadeVO>> resultModel = appFacadeService.page(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者列表失败！-->{}", resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    /**
     * 选项分页查询
     * @param dto
     * @return
     */
    public IPage<AppForItemVO> pageForItem(AppFacadeQueryDTO dto) {
        ResponseEntity<Page<AppFacadeVO>> resultModel = appFacadeService.page(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            Page<AppForItemVO> page = new Page<>();
            BeanUtils.copyProperties(resultModel.getBody(), page);
            List<AppForItemVO> records = new ArrayList<>();
            resultModel.getBody().getRecords().forEach(t -> {
                AppForItemVO item = new AppForItemVO();
                item.setId(t.getId());
                item.setAppId(t.getAppId());
                item.setAppName(t.getAppName());
                item.setPlatformType(t.getPlatformType());
                records.add(item);
            });
            page.setRecords(records);
            return page;
        }
        log.error("开发者后台异常，查询开发者列表失败！-->{}", resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    /**
     * 根据id查询
     * @param id id
     * @return
     */
    public AppFacadeVO get(Long id) {
        ResponseEntity<AppFacadeVO> resultModel = appFacadeService.get(id);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者信息失败！-->{}", resultModel.getStatusCodeValue());
        return null;
    }

    /**
     * 修改
     *
     * @param dto 修改参数
     * @return
     */
    public Boolean update(AppFacadeDTO dto) {
        ResponseEntity<Boolean> resultModel = appFacadeService.update(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，修改开发者信息失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }


    /**
     * 运营后台查询审核页面的 媒体列表
     *
     * @param developerKeyword 公司名称
     * @param appKeyword   应用名称
     * @param status      状态 0待审核， 1审核通过， 2审核拒绝
     * @param current     页码
     * @param size    页面大小
     * @param mjCode      媒介code
     * @return
     */
    public IPage<AppWaitingAuditFacadeVO> getAuditPage(String developerKeyword, String appKeyword, String mjCode, Integer status,Long developerId,Integer current, Integer size) {
        ResponseEntity<Page<AppWaitingAuditFacadeVO>> resultModel = appFacadeService.getAuditPage(developerKeyword, appKeyword, status,developerId, mjCode, current, size);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，获取媒体审核列表失败！-->{}", resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    /**
     * 审核媒体
     *
     * @param id           媒体id
     * @param auditPass    审核通过
     * @param mj         是否是媒介审核
     * @param refuseReason 拒绝原因
     * @param reviewRefuseIds 拒绝原因ID列表
     * @param modifyUser     审核人
     * @return
     */
    public Boolean audit(Long id, Boolean auditPass, Boolean mj, String refuseReason, String reviewRefuseIds, String modifyUser) {
        ResponseEntity<Boolean> resultModel = appFacadeService.audit(id, auditPass, mj, refuseReason, reviewRefuseIds, modifyUser);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，审核媒体失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }


}
