package com.bxm.mccms.common.integration.ssp.developer;

import javax.annotation.Resource;

import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mcssp.facade.model.developer.DeveloperAssignmentFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFinanceListFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFirstAuditResultFacadeVO;
import com.bxm.mcssp.facade.service.DeveloperFinanceFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 开发者财务 远程调用服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-22
 */
@Slf4j
@Service
@EnableFeignClients("com.bxm.mcssp.facade")
public class DeveloperFinanceIntegration {

    @Resource
    private DeveloperFinanceFacadeService developerFinanceFacadeService;

    /**
     * 运营后台开发者分配页列表
     *
     * @param keyword      开发者名称
     * @param financeStatus     财务信息状态
     * @param appStatus       媒体状态
     * @param positionStatus 广告位状态
     * @param mjCode            媒介code
     * @param bdCode            bdCode
     * @param code              开发者代号
     * @param current           页码
     * @param size          页面大小
     * @return
     */
    public IPage<DeveloperAssignmentFacadeVO> getAssignmentPage(String keyword,
                                                                Integer financeStatus,
                                                                Integer appStatus, Integer positionStatus,
                                                                String mjCode, String bdCode,
                                                                Boolean isOrderByDateDesc, String code,
                                                                Integer current, Integer size) {
        ResponseEntity<Page<DeveloperAssignmentFacadeVO>> resultModel =
                developerFinanceFacadeService.getAssignmentPage(keyword, null, financeStatus, appStatus,
                        positionStatus, mjCode, bdCode, isOrderByDateDesc, code, current, size);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者财务管理列表失败！-->{}", resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    /**
     * 运营后台财务信息列表管理
     *
     * @param keyword   邮箱/手机/公司名称/应用名称
     * @param mjCode     媒介code
     * @param developerId 开发者id
     * @param status     状态，-1：未提交 0：待审核，1：审核通过，2：审核拒绝
     * @param current    页码
     * @param size   页面大小
     * @return
     */
    public IPage<DeveloperFinanceListFacadeVO> getAuditPage(String keyword, String mjCode, long developerId,
                                                            Integer status, Integer current, Integer size) {
        ResponseEntity<Page<DeveloperFinanceListFacadeVO>> resultModel =
                developerFinanceFacadeService.getAuditPage(keyword, mjCode, developerId, status, current, size);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者财务管理列表失败！-->{}", resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    /**
     * 审核开发者财务信息
     *
     * @param isRiskController 是否为风控
     * @param developerId       开发者ID
     * @param auditPass        审核通过/拒绝
     * @param refuseReason     拒绝原因
     * @param modifyUser         审核人
     * @return
     */
    public Boolean audit(boolean isRiskController, Long developerId, Boolean auditPass, String refuseReason,
                         String reviewRefuseIds, String modifyUser) {
        ResponseEntity<Boolean> resultModel = developerFinanceFacadeService.audit(developerId, auditPass,
                refuseReason, reviewRefuseIds, modifyUser, isRiskController);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，审核开发者财务信息失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    /**
     * 运营后台开发者分配列表中媒介leader初审
     *
     * @param developerId       开发者ID
     * @param auditPass        审核通过/拒绝
     * @param modifyUser         审核人
     * @param isRiskController 是否为风控
     * @return
     */
    public DeveloperFirstAuditResultFacadeVO firstAudit(Long developerId, Boolean auditPass, String modifyUser,
                                                        boolean isRiskController) {
        ResponseEntity<DeveloperFirstAuditResultFacadeVO> resultModel =
                developerFinanceFacadeService.firstAudit(developerId, auditPass, modifyUser, isRiskController);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，审核开发者信息失败！-->{}", resultModel.getStatusCodeValue());
        return null;
    }

}
