package com.bxm.mccms.common.integration.ssp.developer;

import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import com.bxm.mcssp.facade.service.DeveloperFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 开发者 远程调用服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-22
 */
@Slf4j
@Service
@EnableFeignClients("com.bxm.mcssp.facade")
public class DeveloperIntegration {

    private static final String ERROR_MSG = "调用app服务查询媒体信息失败";

    @Resource
    private DeveloperFacadeService developerFacadeService;

    /**
     * ID和名称数据
     * @param keyword
     * @return
     */
    public List<IDAndNameVO> list(String keyword) {
        ResponseEntity<List<IDAndNameVO>> resultModel = developerFacadeService.list(keyword);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者列表失败！-->{}", resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    /**
     * 分页查询
     * @param dto
     * @return
     */
    public IPage<DeveloperFacadeVO> page(DeveloperFacadeQueryDTO dto) {
        ResponseEntity<Page<DeveloperFacadeVO>> resultModel = developerFacadeService.page(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者列表失败！-->{}", resultModel.getStatusCodeValue());
        return new Page<>();
    }

    /**
     * 根据id查询
     * @param id id
     * @return
     */
    public DeveloperFacadeVO get(Long id) {
        ResponseEntity<DeveloperFacadeVO> resultModel = developerFacadeService.get(id);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询开发者信息失败！-->{}", resultModel.getStatusCodeValue());
        return null;
    }


    /**
     * 修改
     * @param dto
     * @return
     */
    public Boolean update(DeveloperFacadeDTO dto) {
        ResponseEntity<Boolean> resultModel = developerFacadeService.update(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，修改开发者失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    /**
     * 查询开发者列表（不分页）
     *
     * @param dto 查询条件
     * @return
     */
    public List<DeveloperFacadeVO> list(DeveloperFacadeQueryDTO dto) {
        dto.setCurrent(1);
        dto.setSize(-1);
        return this.page(dto).getRecords();
    }

    /**
     * 给开发者设置媒介
     *
     * @param developerId 开发者ID
     * @param mjCode     媒介code
     * @param modifyUser   修改人
     * @return
     */
    public Boolean setMj(Long developerId, String mjCode, String modifyUser) {
        ResponseEntity<Boolean> resultModel = developerFacadeService.setMj(developerId, mjCode, modifyUser);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，给开发者设置媒介失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }


    /**
     * 修改开发者基本数据
     *
     * @param developerId 开发者ID
     * @param mjCode     媒介code
     * @param bdCode     bdcode
     * @param tags       开发者标签
     * @param modifyUser   修改人
     * @return
     */
    public Boolean updateBasic(Long developerId, String mjCode, String bdCode, String tags, String modifyUser) {
        ResponseEntity<Boolean> resultModel = developerFacadeService.updateBasic(developerId, mjCode, bdCode, tags,
                modifyUser);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，给开发者设置标签.媒介.BD失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    /**
     * 模拟开发者登录，获得登录后Token
     *
     * @param developerId 开发者ID
     * @return
     */
    public String simulationLogin(Long developerId) {
        ResponseEntity<String> resultModel = developerFacadeService.simulationLogin(developerId);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，模拟开发者登录失败！-->{}", resultModel.getStatusCodeValue());
        return null;
    }
}
