package com.bxm.mccms.common.integration.ssp.position;

import javax.annotation.Resource;

import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeVO;
import com.bxm.mcssp.facade.service.PositionAssemblyFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 广告位组件 远程调用服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-2-11
 */
@Slf4j
@Service
@EnableFeignClients("com.bxm.mcssp.facade")
public class PositionAssemblyIntegration {

    @Resource
    private PositionAssemblyFacadeService positionAssemblyFacadeService;

    /**
     * 分页查询
     *
     * @param dto 查询条件
     * @return
     */
    public IPage<PositionAssemblyFacadeVO> page(PositionAssemblyFacadeQueryDTO dto) {
        ResponseEntity<Page<PositionAssemblyFacadeVO>> resultModel = positionAssemblyFacadeService.page(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询广告位列表失败！-->{}", resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    /**
     * 修改
     *
     * @param dto 修改参数
     * @return
     */
    public Boolean update(PositionAssemblyFacadeDTO dto) {
        ResponseEntity<Boolean> resultModel = positionAssemblyFacadeService.update(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，修改广告位组件信息失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    /**
     * 修改 状态
     *
     * @param dto 修改参数
     * @return
     */
    public Boolean updateCloseFlag(PositionAssemblyFacadeDTO dto) {
        ResponseEntity<Boolean> resultModel = positionAssemblyFacadeService.updateCloseFlag(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，修改广告位组件信息失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }


}
