package com.bxm.mccms.common.integration.ssp.position;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeDTO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeVO;
import com.bxm.mcssp.facade.service.PositionSdkConfigFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 广告位sdk配置 远程调用服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-1-7
 */
@Slf4j
@Service
@EnableFeignClients("com.bxm.mcssp.facade")
public class PositionSdkConfigIntegration {

    @Autowired
    private PositionSdkConfigFacadeService positionSdkConfigFacadeService;

    /**
     * 保存配置
     * @param dto
     * @return
     */
    public Boolean addConfig(PositionSdkConfigFacadeDTO dto){
        ResponseEntity<Boolean> resultModel = positionSdkConfigFacadeService.addConfig(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，添加广告位SDK配置失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    /**
     * 根据positionId获取配置List
     * @param
     * @return
     */
    public List<PositionSdkConfigFacadeVO> getConfigList(String positionId){
        ResponseEntity<List<PositionSdkConfigFacadeVO>> resultModel =
                positionSdkConfigFacadeService.getConfigList(positionId);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询广告位SDK配置失败！-->{}", resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    /**
     * 同步广告位初始化数据，为每一个广告位添加默认的变现猫渠道
     * @param bxmTypeId
     * @return
     */
    public Boolean syncDefaultPositionSdkConfig(String bxmTypeId){
        ResponseEntity<Boolean> resultModel =
                positionSdkConfigFacadeService.syncDefaultPositionSdkConfig(bxmTypeId);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，同步广告位默认配置数据失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    /**
     * 同步广告位初始化数据，为每一个广告位(激励视频场景)添加默认的变现猫兜底渠道
     * @return
     */
    public Boolean syncDefaultBackupPositionSdkConfig(){
        ResponseEntity<Boolean> resultModel =
                positionSdkConfigFacadeService.syncDefaultBackupPositionSdkConfig();
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，同步广告位默认兜底配置数据失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }


    /**
     * 同步推送所有广告位，广告位配置数据
     * @return
     */
    public Boolean pushAllPositionSdkConfig(){
        ResponseEntity<Boolean> resultModel =
                positionSdkConfigFacadeService.pushAllPositionSdkConfig();
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，同步广告位,广告位SDK配置数据失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    /**
     * 分页查询
     *
     * @param dto 查询条件
     * @return
     */
    public IPage<PositionSdkConfigFacadeVO> page(PositionSdkConfigFacadeQueryDTO dto) {
        ResponseEntity<Page<PositionSdkConfigFacadeVO>> resultModel = positionSdkConfigFacadeService.page(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询广告位列表失败！-->{}", resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    /**
     * 查询list
     * @param
     * @return
     */
    public List<PositionSdkConfigFacadeVO> getList(PositionSdkConfigFacadeQueryDTO dto){
        ResponseEntity<List<PositionSdkConfigFacadeVO>> resultModel = positionSdkConfigFacadeService.getList(dto);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，查询广告位列表失败！-->{}", resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }
}
