package com.bxm.mccms.common.manager.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.model.app.AppAuditDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeQueryDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeVO;
import com.bxm.mcssp.facade.model.app.AppWaitingAuditFacadeVO;

/**
 * <p>
 * 应用相关接口
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-24
 */
public interface AppService {

    /**
     * 应用列表
     *
     * @param user
     * @param dto
     * @return
     */
    IPage<AppFacadeVO> page(UserVo user, AppFacadeQueryDTO dto);

    /**
     * 运营后台查询审核页面的 应用列表
     *
     * @param user 当前登录用户对象
     * @param developerKeyword 邮箱/手机/公司名称
     * @param appKeyword 应用ID/应用名称
     * @param mjCode   媒介code
     * @param status   状态， 0：待审核，1：审核通过，2：审核拒绝
     * @param developerId 开发者id
     * @param current  页码
     * @param size 页面大小
     * @return
     */
    IPage<AppWaitingAuditFacadeVO> getAuditPage(UserVo user, String developerKeyword, String appKeyword, String mjCode, Integer status,
                                                Long developerId, Integer current, Integer size);


    /**
     * 审核应用
     *
     * @param  user  当前登录用户对象
     * @param dto
     * @return
     */
    Boolean audit(UserVo user, AppAuditDTO dto);
}
