package com.bxm.mccms.common.manager.app.impl;

import java.util.Collections;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.app.AppIntegration;
import com.bxm.mccms.common.manager.app.AppService;
import com.bxm.mccms.common.model.app.AppAuditDTO;
import com.bxm.mcssp.common.enums.AuditResultsEnum;
import com.bxm.mcssp.facade.model.app.AppFacadeQueryDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeVO;
import com.bxm.mcssp.facade.model.app.AppWaitingAuditFacadeVO;

import lombok.extern.slf4j.Slf4j;


/**
 * <p>
 * 应用相关接口实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-24
 */
@Slf4j
@Service
public final class AppServiceImpl implements AppService {

    @Autowired
    private AppIntegration appIntegration;

    @Override
    public IPage<AppFacadeVO> page(UserVo user, AppFacadeQueryDTO dto) {
        String mjCode = dto.getMjCode();
        String bdCode = dto.getBdCode();

        // 当登录的mj/bd和传过来参数mj/bd不一致时不查
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank(mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page<>();
            }
            mjCode = user.getUsername();
        }
        if (UserRoleUtil.isBd(user)) {
            if (StringUtils.isNotBlank(bdCode) && !bdCode.equals(user.getUsername())) {
                return new Page<>();
            }
            bdCode = user.getUsername();
        }
        dto.setMjCode(mjCode);
        dto.setBdCode(bdCode);

        //查询审核通过的
        dto.setStatus(AuditResultsEnum.PASS.getStatus());

        return appIntegration.page(dto);
    }

    @Override
    public IPage<AppWaitingAuditFacadeVO> getAuditPage(UserVo user, String developerKeyword, String appKeyword,
                                                       String mjCode, Integer status, Long developerId,
                                                       Integer current, Integer size) {
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        //媒介经理和风控可以看到所有的
        Boolean lookAll = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()) ;
        if (lookAll == false) {
            mjCode = user.getUsername();
        }
        return appIntegration.getAuditPage(developerKeyword, appKeyword, mjCode, status, developerId, current, size);
    }

    @Override
    public Boolean audit(UserVo user, AppAuditDTO dto) {
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        Boolean mj = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode());
        Boolean fk = user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        mj = mj && fk ? false : mj;
        if (!mj && !fk) {
            throw new McCmsException("当前用户角色并无审核操作权限！");
        }
        //媒介/媒介经理是初审，否则就是终审（风控）
        return appIntegration.audit(dto.getAppId(), dto.getAuditPass(), mj, dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
    }
}
