package com.bxm.mccms.common.manager.developer;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.model.developer.DeveloperFinanceAuditDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperAssignmentFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFinanceListFacadeVO;

/**
 * <p>
 * 开发者财务信息相关接口
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-24
 */
public interface DeveloperFinanceService {

    /**
     * 运营后台开发者分配列表
     *
     * @param  user  当前登录用户对象
     * @param keyword 开发者名称
     * @param financeStatus 财务信息状态
     * @param appStatus 媒体状态
     * @param positionStatus 广告位状态
     * @param mjCode 媒介code
     * @param bdCode bdCode
     * @param isOrderByDateDesc 是否按提交时间降序
     * @param code      开发者代号
     * @param current 页码
     * @param size 页面大小
     * @return
     */
    IPage<DeveloperAssignmentFacadeVO> getAssignmentPage(UserVo user, String keyword, Integer financeStatus,
                                                         Integer appStatus, Integer positionStatus, String mjCode, String bdCode,
                                                         Boolean isOrderByDateDesc, String code, Integer current, Integer size);

    /**
     * 运营后台财务信息列表管理
     *
     * @param user 当前登录用户对象
     * @param developerKeyword 邮箱/手机/公司名称
     * @param mjCode   媒介code
     * @param developerId 开发者id
     * @param status   状态， 0：待审核，1：审核通过，2：审核拒绝
     * @param current  页码
     * @param size 页面大小
     * @return
     */
    IPage<DeveloperFinanceListFacadeVO> getAuditPage(UserVo user, String developerKeyword, String mjCode, long developerId,
                                                     Integer status, Integer current, Integer size);

    /**
     * 审核开发者财务信息
     *
     * @param  user  当前登录用户对象
     * @param dto
     * @return
     */
    Boolean audit(UserVo user, DeveloperFinanceAuditDTO dto);

    /**
     * 运营后台开发者分配列表中媒介leader初审
     *
     * @param  user  当前登录用户对象
     * @param developerId   开发者ID
     * @param auditPass    是否审核通过, TRUE通过， FALSE拒绝
     * @return
     */
    Boolean firstAudit(UserVo user, Long developerId, Boolean auditPass);

}
