package com.bxm.mccms.common.manager.developer;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.model.developer.DeveloperLastLoginIpVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;

/**
 * <p>
 * 开发者相关接口
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
public interface DeveloperService {

    /**
     * 分页列表
     * @param user
     * @param dto
     * @return
     */
    IPage<DeveloperFacadeVO> page(UserVo user,  DeveloperFacadeQueryDTO dto);

    /**
     * 获取开发者最后登录IP相同的媒体信息
     * @param developerId
     * @return
     */
    List<DeveloperLastLoginIpVO> getProvideLastLoginIpInfo(Long developerId);

}
