package com.bxm.mccms.common.manager.developer.impl;

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.service.IPositionDspPosService;
import com.bxm.mccms.common.helper.enums.DspStaticEnum;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperFinanceIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.manager.developer.DeveloperFinanceService;
import com.bxm.mccms.common.model.developer.DeveloperFinanceAuditDTO;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.mcssp.facade.model.developer.DeveloperAssignmentFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFinanceListFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFirstAuditResultFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 开发者财务信息相关接口实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-24
 */
@Slf4j
@Service
public class DeveloperFinanceServiceImpl implements DeveloperFinanceService {

    @Autowired
    private DeveloperFinanceIntegration developerFinanceIntegration;
    @Autowired
    private PositionIntegration positionIntegration;

    @Autowired
    private IPositionDspPosService positionDspPosService;

    @Override
    public IPage<DeveloperAssignmentFacadeVO> getAssignmentPage(UserVo user, String keyword, Integer financeStatus,
                                                                Integer appStatus, Integer positionStatus, String mjCode, String bdCode,
                                                                Boolean isOrderByDateDesc, String code, Integer current, Integer size) {
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        //媒介经理和风控可以看到所有的
        Boolean lookAll = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode())
                || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        if (!lookAll) {
            mjCode = user.getUsername();
        }

        IPage<DeveloperAssignmentFacadeVO> auditStatusPage = developerFinanceIntegration.getAssignmentPage(keyword, financeStatus, appStatus,
                positionStatus, mjCode, bdCode, isOrderByDateDesc, code, current, size);
        //设置相关权限
        /* 标签只允许平台运营可风控操作
           编辑只允许媒介经理和风控操作
           审核按钮只允许媒介.媒介经理.风控操作
        * */
        List<DeveloperAssignmentFacadeVO> records = auditStatusPage.getRecords();
        if (CollectionUtils.isNotEmpty(records)) {
            boolean isEditTag = user.getRoleCodes().contains(RoleEnum.PING_TAI_YUN_YING_LEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            boolean isEdit = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            boolean isAudit = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            records.stream().forEach(e -> {
                e.setOperatorAudit(isAudit);
                e.setOperatorEdit(isEdit);
                e.setOperatorTag(isEditTag);
            });
        }
        return auditStatusPage;
    }

    @Override
    public IPage<DeveloperFinanceListFacadeVO> getAuditPage(UserVo user, String developerKeyword, String mjCode, long developerId,
                                                            Integer status, Integer current, Integer size) {
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        //是否为风控角色
        boolean fk = user.getRoleCodes() != null && user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());

        IPage<DeveloperFinanceListFacadeVO> auditPage = developerFinanceIntegration.getAuditPage(developerKeyword, mjCode,developerId, status, current, size);
        if (!fk && auditPage != null && auditPage.getRecords() != null) {
            auditPage.getRecords().stream().forEach(e -> {
                e.setPhoneNum(StringUtils.EMPTY);
                e.setContacts(StringUtils.EMPTY);
            });
        }
        return auditPage;
    }

    @Override
    public Boolean audit(UserVo user, DeveloperFinanceAuditDTO dto) {
        //判断当前用户身份
        List<String> roleCodes = user.getRoleCodes();
        //判断是否具备审核权限
        if (CollectionUtils.isEmpty(roleCodes)) {
            throw new McCmsException("暂无审核权限");
        }
        //是否为风控
        boolean isRiskController;
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode())) {
            isRiskController = false;
        } else {
            throw new McCmsException("暂无审核权限");
        }
        boolean result = developerFinanceIntegration.audit(isRiskController, dto.getDeveloperId(), dto.getAuditPass(), dto.getRefuseReason(),
                dto.getReviewRefuseIds(), user.getUsername());
        if (!result) {
            throw new McCmsException("审核失败！");
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean firstAudit(UserVo user, Long developerId, Boolean auditPass) {
        //判断当前用户身份
        List<String> roleCodes = user.getRoleCodes();
        //判断是否具备审核权限
        if (CollectionUtils.isEmpty(roleCodes)) {
            throw new McCmsException("暂无审核权限");
        }
        //是否为风控 (若同时存在风控与媒介,以风控最高权限为准)
        boolean isRiskController;
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode())) {
            isRiskController = false;
        } else {
            throw new McCmsException("暂无审核权限");
        }
        DeveloperFirstAuditResultFacadeVO vo =
                developerFinanceIntegration.firstAudit(developerId, auditPass, user.getUsername(), isRiskController);
        if (vo == null) {
            throw new McCmsException("审核失败！");
        }
        if (isRiskController && auditPass) {
            //判断是否有锁屏的广告位，需要增加锁屏DSP
            if (CollectionUtils.isNotEmpty(vo.getPositionSuccessIds())) {
                List<PositionFacadeVO> positionFacadeVOList = positionIntegration.findByIds(vo.getPositionSuccessIds());
                if (CollectionUtils.isNotEmpty(positionFacadeVOList)) {
                    for (PositionFacadeVO positionFacadeVO : positionFacadeVOList) {
                        PositionSceneTypeEnum positionSceneTypeEnum =
                                PositionSceneTypeEnum.get(positionFacadeVO.getPositionScene());
                        if (PositionSceneTypeEnum.LOCK_SCREEN == positionSceneTypeEnum) {
                            positionDspPosService.addDsp(positionFacadeVO.getPositionId(), DspStaticEnum.LOCK_SCREET_DSP,
                                    positionFacadeVO.getPositionId());
                        }
                    }
                }
            }
        } else {
            return vo.getResult() == null ? false : vo.getResult();
        }
        return Boolean.TRUE;
    }
}
