package com.bxm.mccms.common.manager.developer.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.helper.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.mccms.common.helper.autoconfigure.config.IPCheckConfig;
import com.bxm.mccms.common.helper.util.HttpUtils;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.manager.developer.DeveloperService;
import com.bxm.mccms.common.model.developer.DeveloperLastLoginIpVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 开发者相关接口实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@Slf4j
@Service
public class DeveloperServiceImpl implements DeveloperService {

    private IPCheckConfig ipCheckConfig;
    
    @Autowired
    private DeveloperIntegration developerIntegration;
    
    public DeveloperServiceImpl(ApplicationGlobalConfig globalConfig){
        this.ipCheckConfig = globalConfig.getIpCheckDeveloper();
    }

    @Override
    public IPage<DeveloperFacadeVO> page(UserVo user, DeveloperFacadeQueryDTO dto) {
        String mjCode = dto.getMjCode();
        String bdCode = dto.getBdCode();

        // 当登录的mj/bd和传过来参数mj/bd不一致时不查
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank(mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page<>();
            }
            mjCode = user.getUsername();
        }
        if (UserRoleUtil.isBd(user)) {
            if (StringUtils.isNotBlank(bdCode) && !bdCode.equals(user.getUsername())) {
                return new Page<>();
            }
            bdCode = user.getUsername();
        }
        dto.setMjCode(mjCode);
        dto.setBdCode(bdCode);

        //查询审核通过的
        dto.setReviewFlag(1);

        return developerIntegration.page(dto);
    }

    @Override
    public List<DeveloperLastLoginIpVO> getProvideLastLoginIpInfo(Long developerId) {
        DeveloperFacadeVO developerFacadeVO = developerIntegration.get(developerId);
        String ip = developerFacadeVO.getLastLoginIp();
        if(StringUtils.isBlank(ip)){
            return Collections.emptyList();
        }
        //String requestUrl = "http://172.16.20.106:17861/credit/ads/selectIpAndCheckAppkey?ip=";//测试
        //String requestUrl = "http://172.21.0.10:17861/credit/ads/selectIpAndCheckAppkey?ip=";//生产
        String requestUrl = "http://"+ipCheckConfig.getIp()+":"+ipCheckConfig.getPort()+"/credit/ads/selectIpAndCheckAppkey?ip=" + ip;

        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResp = null;
        try {
            httpClient = HttpUtils.createHttpClient();
            //设置超时
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(2000).setSocketTimeout(5000).build();
            HttpPost httpPost = new HttpPost(requestUrl);
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-Type","application/x-www-form-urlencoded");

            httpResp = httpClient.execute(httpPost);
            String result = EntityUtils.toString(httpResp.getEntity());
            JSONObject jsonObject = JSONObject.parseObject(result);
            if(jsonObject.getBoolean("success")){
                JSONArray data = jsonObject.getJSONArray("data");
                List<DeveloperLastLoginIpVO> list = JSONObject.parseArray(data.toJSONString(), DeveloperLastLoginIpVO.class);
                return list;
            }
        } catch (IOException e) {
            log.error("请求IP信息异常：{}", e.getMessage());
            return Collections.emptyList();
        } finally {
            HttpUtils.close(httpResp);
            HttpUtils.close(httpClient);
        }
        return Collections.emptyList();
    }

}
