package com.bxm.mccms.common.manager.position;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.integration.assembly.AssemblyList;
import com.bxm.mccms.common.model.position.PositionAssemblyDataVO;
import com.bxm.mccms.common.model.position.PositionAssemblyTotalQueryDTO;
import com.bxm.mccms.common.model.position.PositionAssemblyUpdateDTO;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeVO;

/**
 * <p>
 * 广告位组件相关接口
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-2-11
 */
public interface PositionAssemblyService {

    /**
     * 查询广告位组件配置列表信息
     *
     * @param user
     * @param dto
     * @return
     */
    IPage<PositionAssemblyFacadeVO> page(UserVo user, PositionAssemblyFacadeQueryDTO dto);

    /**
     * 广告位组件下拉框列表信息-id和名称
     * @return
     */
    List<IDAndNameVO> assemblyList();

    /**
     * 某个广告位绑定的组件列表数据
     * @param page
     * @param positionId
     * @param pname 组件名称
     * @return
     */
    IPage<AssemblyList> positionBindAssemblyPage(Page page, String positionId, String pname);

    /**
     * 更新
     *
     * @param user
     * @param dto
     * @return
     */
    Boolean update(UserVo user, PositionAssemblyUpdateDTO dto);

    /**
     * 更新 状态
     *
     * @param user
     * @param dto
     * @return
     */
    Boolean updateCloseFlag(UserVo user, PositionAssemblyFacadeDTO dto);


    /**
     * 组件汇总数据列表分页
     *
     * @param page
     * @param dto
     * @return
     */
    IPage<PositionAssemblyDataVO> assemblyTotalDataPage(Page page, PositionAssemblyTotalQueryDTO dto);

    /**
     * 组件明细数据列表分页
     *
     * @param page
     * @param dto
     * @return
     */
    IPage<PositionAssemblyDataVO> assemblyDetailDataPage(Page page, PositionAssemblyTotalQueryDTO dto);


}
