package com.bxm.mccms.common.manager.position;

import java.math.BigDecimal;
import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.model.position.PositionAuditDTO;
import com.bxm.mccms.common.model.position.PositionFlowDTO;
import com.bxm.mccms.common.model.position.PositionFlowVO;
import com.bxm.mcssp.facade.model.position.PositionAuditFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;

/**
 * <p>
 * 广告位相关接口
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-24
 */
public interface PositionService {

    /**
     * 列表
     *
     * @param user
     * @param dto
     * @return
     */
    IPage<PositionFacadeVO> page(UserVo user, PositionFacadeQueryDTO dto);

    /**
     * 更新
     *
     * @param user
     * @param dto
     * @return
     */
    Boolean update(UserVo user, PositionFacadeDTO dto);

    /**
     * 运营后台查询审核页面的 广告位列表
     *
     * @param user 当前登录用户对象
     * @param developerKeyword 邮箱/手机/公司名称
     * @param appKeyword 应用ID/应用名称
     * @param positionKeyword 广告位ID/广告位名称
     * @param status   状态， 0：待审核，1：审核通过，2：审核拒绝
     * @param developerId 开发者id
     * @param mjCode   媒介code
     * @param current  页码
     * @param size 页面大小
     * @return
     */
    IPage<PositionAuditFacadeVO> getAuditPage(UserVo user, String developerKeyword, String appKeyword,
                                              String positionKeyword, Integer status, Long  developerId,
                                              String mjCode, Integer current, Integer size);

    /**
     * 批量审核广告位
     *
     * @param  user  当前登录用户对象
     * @param dto
     * @return
     */
    Boolean batchAudit(UserVo user, PositionAuditDTO dto);



    /**
     * 广告位流量分配
     *
     * @param page
     * @param dto
     * @return
     */
    IPage<PositionFlowVO> pageForFlow(Page page, PositionFlowDTO dto);

    /**
     * 流量开关<br/>
     *
     * @param positionId 广告位ID
     * @param closedFlag 是否已关闭：1 表示已关闭，0 表示未关闭
     * @param username 操作用户
     */
    boolean updateFlow(String positionId, Integer closedFlag, String username);

    /**
     * 获取底价<br/>
     *
     * @param positionId 广告位ID
     */
    BigDecimal getBasePrice(String positionId);


    //场景DSP
    /**
     * 获取广告位对应的应用下审核通过的所有的广告位类型为“激励视频”的广告位ID、名称、广告位状态（开启or关闭）
     * @param positionId
     * @return
     */
    List<PositionFacadeVO> listForSceneDsp(String positionId, Integer positionScene, Integer informationFlowTemplate);
}
