package com.bxm.mccms.common.manager.position.impl;


import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.datapark.web.model.AssemblyData;
import com.bxm.datapark.web.model.AssemblyDataDTO;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.assembly.AssemblyIntegration;
import com.bxm.mccms.common.integration.assembly.AssemblyList;
import com.bxm.mccms.common.integration.assembly.PageModel;
import com.bxm.mccms.common.integration.assembly.ResultModel;
import com.bxm.mccms.common.integration.datapark.DataparkWebIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionAssemblyIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.manager.position.PositionAssemblyService;
import com.bxm.mccms.common.model.position.PositionAssemblyDataVO;
import com.bxm.mccms.common.model.position.PositionAssemblyTotalQueryDTO;
import com.bxm.mccms.common.model.position.PositionAssemblyUpdateDTO;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;


/**
 * <p>
 * 广告位组件相关接口实现类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-2-11
 */
@Service
public class PositionAssemblyServiceImpl implements PositionAssemblyService {

    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private PositionAssemblyIntegration positionAssemblyIntegration;
    @Autowired
    private AssemblyIntegration assemblyIntegration;
    @Autowired
    private DataparkWebIntegration dataparkWebIntegration;


    @Override
    public IPage<PositionAssemblyFacadeVO> page(UserVo user, PositionAssemblyFacadeQueryDTO dto) {
        String mjCode = dto.getMjCode();

        // 当登录的mj/bd和传过来参数mj/bd不一致时不查
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank(mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page<>();
            }
            mjCode = user.getUsername();
        }
        dto.setMjCode(mjCode);

        return positionAssemblyIntegration.page(dto);
    }

    @Override
    public List<IDAndNameVO> assemblyList() {
        Page page = new Page();
        page.setCurrent(1);
        page.setSize(Integer.MAX_VALUE);
        String positionId = "一个无意义的广告位ID";
        IPage<AssemblyList> assemblyPage = positionBindAssemblyPage(page, positionId, null);
        ArrayList<IDAndNameVO> resultList = new ArrayList<>();
        if (assemblyPage != null && CollectionUtils.isNotEmpty(assemblyPage.getRecords())) {
            List<AssemblyList> records = assemblyPage.getRecords();
            for (AssemblyList record : records) {
                IDAndNameVO idAndNameVO = new IDAndNameVO();
                idAndNameVO.setId(Long.valueOf(record.getId()));
                idAndNameVO.setName(record.getName());
                resultList.add(idAndNameVO);
            }
        }
        return resultList;
    }

    @Override
    public IPage<AssemblyList> positionBindAssemblyPage(Page page, String positionId, String pname) {
        ResultModel<PageModel<AssemblyList>> resultModel = assemblyIntegration.getList(positionId, pname,
                Long.valueOf(page.getCurrent()).intValue(),
                Long.valueOf(page.getSize()).intValue());
        PageModel<AssemblyList> returnValue = resultModel.getReturnValue();
        page.setRecords(returnValue.getList());
        page.setTotal(returnValue.getTotal());
        return page;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean update(UserVo user, PositionAssemblyUpdateDTO dto) {
        dto.setModifyTime(LocalDateTime.now());
        dto.setModifyUser(user.getUsername());

        String ids = dto.getPids();
        List<Integer> idList = null;
        if(StringUtils.isNotBlank(ids)){
            String[] idArray = ids.split(",");
            if (idArray.length > 0) {
                idList = new ArrayList<>(idArray.length);
                for (String id : idArray) {
                    idList.add(Integer.valueOf(id));
                }
            }
        }
        ResultModel<Boolean> bind = assemblyIntegration.bind(dto.getPositionId(), idList);
        Boolean result = false;
        if (bind != null && bind.isSuccessed()) {
            result = positionAssemblyIntegration.update(dto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean updateCloseFlag(UserVo user, PositionAssemblyFacadeDTO dto) {
        dto.setModifyTime(LocalDateTime.now());
        dto.setModifyUser(user.getUsername());
        Boolean result = positionAssemblyIntegration.updateCloseFlag(dto);
        return result;
    }


    @Override
    public IPage<PositionAssemblyDataVO> assemblyTotalDataPage(Page page, PositionAssemblyTotalQueryDTO dto) {
        AssemblyDataDTO search = new AssemblyDataDTO();
        search.setGroup(AssemblyDataDTO.POSTION);
        search.setStartDate(dto.getStartDate());
        search.setEndDate(dto.getEndDate());
        search.setPageSize(Long.valueOf(page.getSize()).intValue());
        search.setPageNum(Long.valueOf(page.getCurrent()).intValue());

        if (StringUtils.isNotBlank(dto.getPositionKeyword())) {
            PositionFacadeQueryDTO positionFacadeQueryDTO = new PositionFacadeQueryDTO();
            positionFacadeQueryDTO.setPositionKeyword(dto.getPositionKeyword());
            List<String> positionIds = positionIntegration.getAllPositionIds(positionFacadeQueryDTO);
            if (CollectionUtils.isNotEmpty(positionIds)) {
                search.setPositionIds(positionIds);
            }
        }
        com.bxm.datapark.facade.Page<AssemblyData> assemblyDataPage = dataparkWebIntegration.getAssemblyData(search);
        if (assemblyDataPage == null) {
            return page;
        }
        List<AssemblyData> assemblyDataList = assemblyDataPage.getList();
        if (CollectionUtils.isEmpty(assemblyDataList)) {
            return page;
        }
        AssemblyDataDTO pageDataSearch = new AssemblyDataDTO();
        BeanUtils.copyProperties(search, pageDataSearch);
        pageDataSearch.setGroup(AssemblyDataDTO.ALL);
        pageDataSearch.setPageSize(1);
        pageDataSearch.setPageNum(1);
        com.bxm.datapark.facade.Page<AssemblyData> assemblyPageDataPage = dataparkWebIntegration.getAssemblyData(pageDataSearch);
        if (assemblyPageDataPage != null && CollectionUtils.isEmpty(assemblyDataPage.getList())) {
            assemblyDataPage.getList().addAll(0, assemblyPageDataPage.getList());
        }

        List<String> positionIds = assemblyDataList.stream().filter(v -> StringUtils.isNotBlank(v.getPositionId())).map(AssemblyData::getPositionId).distinct().collect(Collectors.toList());
        List<PositionFacadeVO> positionList = positionIntegration.findListByPositionIds(positionIds);
        Map<String, PositionFacadeVO> positionMap = positionList.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);

        List<PositionAssemblyDataVO> records = new ArrayList();
        for (AssemblyData assemblyData : assemblyDataList) {
            PositionAssemblyDataVO positionAssemblyDataVO = new PositionAssemblyDataVO();
            BeanUtils.copyProperties(assemblyData, positionAssemblyDataVO);
            positionAssemblyDataVO.setPositionName(positionMap.getOrDefault(assemblyData.getPositionId(), new PositionFacadeVO()).getPositionName());
            records.add(positionAssemblyDataVO);
        }
        page.setRecords(records);
        page.setTotal(assemblyDataPage.getTotal());
        return page;
    }

    @Override
    public IPage<PositionAssemblyDataVO> assemblyDetailDataPage(Page page, PositionAssemblyTotalQueryDTO dto) {
        AssemblyDataDTO search = new AssemblyDataDTO();

        if (StringUtils.isNotBlank(dto.getPositionId())) {
            List<String> positionIds = new ArrayList<>();
            positionIds.add(dto.getPositionId());
            search.setPositionIds(positionIds);
        }

        if (dto.getPid() != null) {
            List<Integer> pids = new ArrayList<>();
            pids.add(dto.getPid());
            search.setPids(pids);
        }
        search.setStartDate(dto.getStartDate());
        search.setEndDate(dto.getEndDate());
        search.setPageSize(Long.valueOf(page.getSize()).intValue());
        search.setPageNum(Long.valueOf(page.getCurrent()).intValue());

        com.bxm.datapark.facade.Page<AssemblyData> assemblyDataPage = dataparkWebIntegration.getAssemblyData(search);
        List<AssemblyData> assemblyDataList = assemblyDataPage.getList();
        if (assemblyDataPage == null || CollectionUtils.isEmpty(assemblyDataList)) {
            return page;
        }

        List<PositionAssemblyDataVO> records = new ArrayList();
        for (AssemblyData assemblyData : assemblyDataList) {
            PositionAssemblyDataVO positionAssemblyDataVO = new PositionAssemblyDataVO();
            BeanUtils.copyProperties(assemblyData, positionAssemblyDataVO);
            records.add(positionAssemblyDataVO);
        }
        page.setRecords(records);
        page.setTotal(assemblyDataPage.getTotal());
        return page;
    }
}
