package com.bxm.mccms.common.model.app;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * <p>
 * 应用审核相关信息
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-28
 */
@Data
public class AppAuditDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 审核的id
     */
    @NotNull(message = "应用ID不能为空！")
    private Long appId;

    /**
     * 是否审核通过, TRUE通过， FALSE拒绝
     */
    @NotNull(message = "审核不能为空！")
    private Boolean auditPass;

    /**
     * 拒绝原因ID列表
     */
    private String reviewRefuseIds;

    /**
     * 广告位状态：1通过,2拒绝
     */
    private String refuseReason;

}
