package com.bxm.mccms.common.model.developer;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * <p>
 * 开发者财务信息 审核对象
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-28
 */
@Data
public class DeveloperFinanceAuditDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 开发者ID
     */
    @NotNull(message = "开发者ID不能为空！")
    private Long developerId;

    /**
     * 是否审核通过, TRUE通过， FALSE拒绝
     */
    @NotNull(message = "审核不能为空！")
    private Boolean auditPass;

    /**
     * 审核拒绝原因描述
     */
    @NotBlank(message = "审核拒绝原因不能为空！")
    private String refuseReason;

    /**
     * 审核拒绝原因ID
     */
    private String reviewRefuseIds;


}
