package com.bxm.mccms.common.model.developer;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * <p>
 * 开发者 修改基本信息对象,用于设置媒介和商务,以及标签
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-28
 */
@Data
public class DeveloperUpdateBaseDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 开发者ID
     */
    @NotNull(message = "开发者ID不能为空！")
    private Long developerId;

    /**
     * 媒介
     */
    private String mjCode;

    /**
     * 商务
     */
    private String bdCode;

    /**
     * 标签
     */
    private String tags;


}
