package com.bxm.mccms.common.model.dsp;

import java.util.Date;

import com.bxm.mccms.common.model.base.BaseDTO;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 广告位创意审核-请求信息<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/23 15:34
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class DspCreativeDTO extends BaseDTO {

    /**
     * 创意ID
     */
    private Long id;
    /**
     * 风控审核态,0:待审核,1:机审通过,2:机审不通过,3:通过,4:不通过
     */
    private Integer auditStatus;
    /**
     * 推送时间,开始
     */
    private Date pushTimeStart;
    /**
     * 推送时间,结束
     */
    private Date pushTimeEnd;
}
