package com.bxm.mccms.common.model.dsp;

import com.bxm.mccms.common.model.base.BaseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 广告位创意审核-请求信息<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/23 15:34
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PositionDspCreativeDTO extends BaseDTO {

    /**
     * 风控审核态,0:待审核,1:机审通过,2:机审不通过,3:通过,4:不通过
     */
    private Integer diskAuditStatus;
    /**
     * 风控审核态,0:待审核,1:机审通过,2:机审不通过,3:通过,4:不通过
     */
    private List<Integer> diskAuditStatusList;
    /**
     * 媒体/媒介运营审核状态,0:待审核,1:通过,2:不通过
     */
    private Integer opAuditStatus;
    /**
     * 广告类型,1:落地页,2:下载,3:deeplink类
     */
    private Integer creativeType;
    /**
     * 广告位名称
     */
    private String positionName;
    /**
     * 广告位场景：1:开屏，2 互动
     */
    private Integer positionScene;
    /**
     * 创意ID
     */
    private Long creativeId;
    /**
     * 广告来源
     */
    private Integer dspId;
    /**
     * 推送时间,开始
     */
    private Date pushTimeStart;
    /**
     * 推送时间,结束
     */
    private Date pushTimeEnd;
    /**
     * 应用ID
     */
    private Long appId;
    /**
     * 媒体运营代码
     */
    private Long mjCode;
    
    public void addDiskAuditStatus(Integer... diskAuditStatus){
        if(null == diskAuditStatus){
            return ;
        }
        if(null == diskAuditStatusList){
            diskAuditStatusList = new ArrayList<>();
        }
        for(Integer auditStatus : diskAuditStatus){
            diskAuditStatusList.add(auditStatus);
        }
    }
}
