package com.bxm.mccms.common.model.dsp;

import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 广告位创意审核-响应信息<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/23 13:58
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PositionDspCreativeVO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 创意ID
     */
    private Long id;
    /**
     * 广告类型,1:落地页,2:下载,3:deeplink类
     */
    private Integer creativeType;
    /**
     * 跳转地址,广告类型为落地页：落地页地址,为下载类：下载地址,为deeplink：depplink路径
     */
    private String jumpUrl;
    /**
     * 创意标题
     */
    private String creativeTitle;
    /**
     * 创意图片,如：[{"url":"图片地址","w":"宽度","h":"高度","ds":"磁盘存储大小,单位:B","fmt":"格式,如:JPG"}]
     */
    private String creativePicture;
    /**
     * 创意视频,如：{"url":"视频地址","w":"宽度","h":"高度","ds":"磁盘存储大小,单位:B","fmt":"格式,如:MP4","dt":"时长,毫秒"}
     */
    private String creativeVideo;
    /**
     * 广告来源
     */
    private String dspName;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 广告位名称
     */
    private String positionName;
    /**
     * 广告位场景：1:开屏，2 互动
     */
    private Integer positionScene;
    /**
     * 媒体运营代码
     */
    private String mjCode;
    /**
     * 媒体运营
     */
    private String mjName;
    /**
     * 推送时间
     */
    private Date pushTime;
    /**
     * 运营审核时间
     */
    private Date opAuditTime;
    /**
     * 运营备注
     */
    private String opRemark;
    /**
     * 运营审核状态
     */
    private Integer opAuditStatus;
}
