package com.bxm.mccms.common.model.income;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 19:32
 */
@Data
public class DeveloperBillVO implements Serializable {
    private static final long serialVersionUID = -8495050485906100143L;

    private Long id;
    /**
     * 日期
     */
    private String month;

    /**
     * 开发者id
     */
    private Long developerId;
    private String developerName;

    /**
     * 业务类型
     */
    private Integer businessType =1;

    /**
     * 平台总消耗
     */
    private BigDecimal totalConsume;

    /**
     * 开发者实际收入
     */
    private BigDecimal developerIncome;

    /**
     * 可提现金额
     */
    private BigDecimal cashMoney;


    private String deductionLog;


    /**
     * 状态：0待确认账单，1已经确认账单，2申请提现中，3提现拒绝，4，已经提现，-1，其他
     */
    private Integer status;

    private String mj;

}
