package com.bxm.mccms.common.model.income;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 16:50
 */
@Data
public class DeveloperIncomeVO implements Serializable {

    private static final long serialVersionUID = 8944078424186816604L;

    private Long id;

    /**
     * 日期
     */

    @JsonFormat(pattern = "yyyy-MM-dd")
    private String datetime;

    /**
     * 开发者id
     */
    private Long developerId;
    private String developerName;


    /**
     * 总请求量
     */
    private Long totalSend;

    /**
     * 总曝光量
     */
    private Long totalOpen;

    /**
     * 总点击量
     */
    private Long totalClick;

    /**
     * 上游平台消耗
     */
    private BigDecimal totalIncome;


    /**
     * 公司预估收益
     */
    private BigDecimal bxmPreIncome;

    /**
     * 开发者预估收益
     */
    private BigDecimal developerPreIncome;


    /**
     * 状态：0未提交，1已经提交，2已经确认，
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;

}
