package com.bxm.mccms.common.model.income;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 19:32
 */
@Data
public class DeveloperWithdrawlVO implements Serializable {
    private static final long serialVersionUID = -8495050485906100143L;
    private Long id;
    /**
     * 开发者id
     */
    //@Excel(name = "开发者ID",type = 10 )
    private Long developerId;

    /**
     * 开发者名称
     */
    @Excel(name = "开发者名称" )
    private String developerName;

    /**
     * 公司名称
     */
    @Excel(name = "公司名称")
    private String companyName;
    /**
     * 日期
     */
    @Excel(name = "月份")
    private String month;

    /**
     * 平台总消耗
     */
    @Excel(name = "预估上游消耗",type = 10)
    private BigDecimal totalConsume;

    /**
     * 开发者收益
     */
    @Excel(name = "开发者预估收益" ,type = 10)
    private BigDecimal developerIncome;

    /**
     * 可提现金额
     */
    @Excel(name = "可提现金额",type = 10)
    private BigDecimal cashMoney;

    /**
     * 证件信息
     */
    @Excel(name = "证件信息")
    private String licenseNo;

    /**
     * 营业执照
     */
    @Excel(name = "营业执照")
    private String licensePicUrl;

    /**
     * 开户许可证
     */
    @Excel(name = "开户许可证")
    private String openingPermitPicUrl;

    /**
     * 开户银行信息
     */
    @Excel(name = "开户银行信息")
    private String bankInfo;

    /**
     * 提现信息
     */
    @Excel(name = "提现信息")
    private String withdrawalInfo;

    /**
     * 提现时间
     */
    @Excel(name = "提现时间",format="yyyy-MM-dd HH:mm:ss")
    private Date withdrawalTime;

    /**
     * 公司信息
     */
    @Excel(name = "公司信息")
    private String companyInfo;

    /**
     * 状态：0待确认账单，1已经确认账单，2申请提现中，3提现拒绝，4，已经提现，-1，其他
     */
    private Integer status;

    @Excel(name = "提现状态")
    private String statusInfo;

    public String getStatusInfo() {
        if (status == null){
            return "";
        }
        if (status == 1){
            return "待开发者确认账单";
        }
        if (status == 2){
            return "开发者已确认账单";
        }
        if (status == 3){
            return "申请提现中";
        }
        if (status == 4){
            return "提现拒绝";
        }
        if (status == 5){
            return "已经提现";
        }
        return statusInfo;
    }

    private String createUser;
    //@Excel(name = "创建时间")
    private Date createTime;

    private String modifyUser;
    //@Excel(name = "修改时间")
    private Date modifyTime;

}
